/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.export.CharacterExportPlugin;
import de.rpgframework.genericrpg.export.ExportPluginRegistry;
import de.rpgframework.jfx.pages.CharacterExportPluginConfigPane;
import de.rpgframework.jfx.pages.CharacterViewLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.TilePane;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.Page;

public class CharacterExportPluginSelectorPage<C extends RuleSpecificCharacterObject<?, ?, ?, ?>>
extends Page {
    private static final System.Logger logger = System.getLogger(CharacterExportPluginSelectorPage.class.getPackageName());
    private static final ResourceBundle RES = ResourceBundle.getBundle(CharacterViewLayout.class.getName());
    private C character;
    private List<Button> buttons;
    private TilePane tiles;

    public CharacterExportPluginSelectorPage(C charac) {
        super(ResourceI18N.get((ResourceBundle)RES, (String)"dialog.exportpluginselector.title"), null);
        this.character = charac;
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.buttons = new ArrayList<Button>();
        List plugins = ExportPluginRegistry.getCharacterExportPlugins(this.character);
        for (CharacterExportPlugin plugin : plugins) {
            Button button = new Button(plugin.getName(Locale.getDefault()));
            button.setContentDisplay(ContentDisplay.TOP);
            button.setUserData((Object)plugin);
            button.setWrapText(true);
            button.setStyle("-fx-border-width: 0px; -fx-font-size: 150%; -fx-max-width: 150px");
            byte[] imgData = plugin.getIcon();
            if (imgData != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(imgData);
                ImageView iView = new ImageView(new Image((InputStream)bis));
                iView.setPreserveRatio(true);
                iView.setFitHeight(150.0);
                button.setGraphic((Node)iView);
            }
            this.buttons.add(button);
        }
    }

    private void initLayout() {
        this.tiles = new TilePane(20.0, 20.0);
        this.tiles.getChildren().addAll(this.buttons);
        this.setContent((Node)this.tiles);
    }

    private void initInteractivity() {
        for (Button btn : this.buttons) {
            btn.setOnAction(ev -> this.export((CharacterExportPlugin)btn.getUserData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(CharacterExportPlugin<C> plugin) {
        logger.log(System.Logger.Level.INFO, "Export ''{0}'' using ''{1}''/{2}", this.character.getName(), plugin.getName(Locale.getDefault()), plugin.getClass());
        try {
            CharacterExportPluginConfigPane config = new CharacterExportPluginConfigPane(plugin);
            CloseType closed = FlexibleApplication.getInstance().showAlertAndCall(new ManagedDialog(ResourceI18N.get((ResourceBundle)RES, (String)"dialog.exportpluginselector.configs"), (Node)config, new CloseType[]{CloseType.OK, CloseType.CANCEL}), null);
            if (closed == CloseType.CANCEL) {
                return;
            }
            byte[] data = null;
            try {
                data = plugin.createExport(this.character);
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.log(System.Logger.Level.ERROR, "Error in export plugin", e);
                logger.log(System.Logger.Level.DEBUG, "Close selector pane");
                FlexibleApplication.getInstance().closeScreen();
                return;
            }
            try {
                Path temp = Files.createTempFile(this.character.getName(), plugin.getFileType(), new FileAttribute[0]);
                Files.write(temp, data, new OpenOption[0]);
                logger.log(System.Logger.Level.WARNING, "Wrote to " + String.valueOf(temp));
                BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.OPEN_FILE, (Object[])new Object[]{temp});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "Close selector pane");
            FlexibleApplication.getInstance().closeScreen();
        }
    }
}

