/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.GenericCore;
import de.rpgframework.jfx.cells.DataSetListCell;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.prelle.javafx.Page;

public class DatasetsPage
extends Page {
    private static final System.Logger logger = System.getLogger(DatasetsPage.class.getPackageName());
    private static final ResourceBundle RES = ResourceBundle.getBundle(DatasetsPage.class.getPackageName() + ".Pages");
    private ListView<DataSet> listView;

    public DatasetsPage() {
        super(ResourceI18N.get((ResourceBundle)RES, (String)"page.datasets.title"));
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.refresh();
    }

    private void initComponents() {
        this.listView = new ListView<DataSet>(){};
        this.listView.setMaxHeight(Double.MAX_VALUE);
        this.listView.setCellFactory(lv -> new DataSetListCell(null));
        this.listView.setStyle("-fx-max-width: 50em");
    }

    private void initLayout() {
        Text pre = new Text(ResourceI18N.get((ResourceBundle)RES, (String)"page.datasets.descr.pre"));
        pre.setStyle("-fx-fill: -fx-text-base-color");
        Text mid = new Text(" " + ResourceI18N.get((ResourceBundle)RES, (String)"page.datasets.descr.mid") + " ");
        mid.setStyle("-fx-fill: green");
        Text post = new Text(ResourceI18N.get((ResourceBundle)RES, (String)"page.datasets.descr.post"));
        post.setStyle("-fx-fill: -fx-text-base-color; -fx-font-size: 14px;");
        TextFlow flow = new TextFlow(new Node[]{pre, mid, post});
        flow.setLineSpacing(10.0);
        VBox layout = new VBox(new Node[]{flow, this.listView});
        layout.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.listView, (Priority)Priority.ALWAYS);
        this.setContent((Node)layout);
    }

    private void initInteractivity() {
        this.listView.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            if (n == null) {
                return;
            }
        });
    }

    public void refresh() {
        this.listView.getItems().setAll((Collection)GenericCore.getDataSets());
        Collections.sort(this.listView.getItems(), new Comparator<DataSet>(){

            @Override
            public int compare(DataSet ds1, DataSet ds2) {
                try {
                    int i = Integer.compare(ds1.getType().ordinal(), ds2.getType().ordinal());
                    if (i != 0) {
                        return i;
                    }
                    i = Integer.compare(ds1.getReleased(), ds2.getReleased());
                    if (i != 0) {
                        return i;
                    }
                    return ds1.getName(Locale.getDefault()).compareTo(ds2.getName(Locale.getDefault()));
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Error comparing DataSet", (Throwable)e);
                    return 0;
                }
            }
        });
    }
}

