/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.rules;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.data.AttributeValue;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.jfx.rules.skin.AttributeTableSkin;
import de.rpgframework.jfx.rules.skin.Properties;
import java.util.function.BiFunction;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class AttributeTable<A extends IAttribute>
extends Control {
    @FXML
    private ObjectProperty<Mode> mode = new SimpleObjectProperty();
    @FXML
    private A[] attributes;
    private ObjectProperty<RuleSpecificCharacterObject<A, ?, ?, ?>> model = new SimpleObjectProperty();
    private ObjectProperty<IAttribute> selectedAttribute = new SimpleObjectProperty();
    private ObjectProperty<NumericalValueController<A, AttributeValue<A>>> controller = new SimpleObjectProperty();
    private ObservableList<AttributeColumn> columns = FXCollections.observableArrayList();

    public AttributeTable() {
    }

    public AttributeTable(A[] attributes) {
        this.attributes = attributes;
        this.mode.set((Object)Mode.SHOW_ONLY);
    }

    public AttributeTable<A> setAttributes(A[] attributes) {
        return this;
    }

    public Skin<?> createDefaultSkin() {
        return new AttributeTableSkin(this);
    }

    public Mode getMode() {
        return (Mode)((Object)this.mode.get());
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.mode;
    }

    public AttributeTable<A> setMode(Mode value) {
        this.mode.set((Object)value);
        return this;
    }

    public A[] getAttributes() {
        return this.attributes;
    }

    public ObjectProperty<RuleSpecificCharacterObject<A, ?, ?, ?>> modelProperty() {
        return this.model;
    }

    public RuleSpecificCharacterObject<A, ?, ?, ?> getModel() {
        return (RuleSpecificCharacterObject)this.model.get();
    }

    public AttributeTable<A> setModel(RuleSpecificCharacterObject<A, ?, ?, ?> value) {
        this.model.set(value);
        return this;
    }

    public ObjectProperty<IAttribute> selectedAttributeProperty() {
        return this.selectedAttribute;
    }

    public IAttribute getSelectedAttribute() {
        return (IAttribute)this.selectedAttribute.get();
    }

    public AttributeTable<A> setSelectedAttribute(IAttribute value) {
        this.selectedAttribute.set((Object)value);
        return this;
    }

    public ObjectProperty<NumericalValueController<A, AttributeValue<A>>> controllerProperty() {
        return this.controller;
    }

    public NumericalValueController<A, AttributeValue<A>> getController() {
        return (NumericalValueController)this.controller.get();
    }

    public AttributeTable<A> setController(NumericalValueController<A, AttributeValue<A>> value) {
        this.controller.set(value);
        return this;
    }

    public ObservableList<AttributeColumn> getColumns() {
        return this.columns;
    }

    public void refresh() {
        this.getProperties().put((Object)Properties.RECREATE, (Object)Boolean.TRUE);
    }

    public static enum Mode {
        SHOW_ONLY,
        DIRECT_INPUT,
        GENERATE,
        CAREER;

    }

    public static class AttributeColumn<A extends IAttribute> {
        private boolean beforeValueColumn = false;
        private String title;
        private BiFunction<RuleSpecificCharacterObject<A, ?, ?, ?>, A, Object> valueFactory;
        private BiFunction<A, Object, Node> componentFactory;

        public AttributeColumn(BiFunction<RuleSpecificCharacterObject<A, ?, ?, ?>, A, Object> valueFact, BiFunction<A, Object, Node> componentFact) {
            this.valueFactory = valueFact;
            this.componentFactory = componentFact;
        }

        public boolean isShowBeforeValueColumn() {
            return this.beforeValueColumn;
        }

        public BiFunction<RuleSpecificCharacterObject<A, ?, ?, ?>, A, Object> getValueFactory() {
            return this.valueFactory;
        }

        public BiFunction<A, Object, Node> getComponentFactory() {
            return this.componentFactory;
        }

        public void setTitle(String value) {
            this.title = value;
        }

        public void setShowBeforeColumn(boolean value) {
            this.beforeValueColumn = true;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

