/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.rules.skin;

import de.rpgframework.genericrpg.chargen.SingleComplexDataItemController;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.jfx.BlankableValueControl;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.TextAlignment;
import org.prelle.javafx.SymbolIcon;

public class BlankableValueControlSkin<D extends ComplexDataItem, V extends ComplexDataItemValue<D>>
extends SkinBase<BlankableValueControl<D, V>> {
    private final String DASHED = "-fx-border-insets: 0;\n-fx-border-width: 1;\n-fx-stroke-dashed-offset: 5;\n-fx-border-style: dashed;\n";
    private ToggleButton button;
    private SymbolIcon icoAdd;
    private SymbolIcon icoDel;

    public BlankableValueControlSkin(BlankableValueControl<D, V> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.refresh();
    }

    private void initComponents() {
        this.icoAdd = new SymbolIcon("add");
        this.icoDel = new SymbolIcon("delete");
        this.icoAdd.getStyleClass().add((Object)"mini-icon");
        this.icoDel.getStyleClass().add((Object)"mini-icon");
        this.button = new ToggleButton();
        this.button.setMaxWidth(Double.MAX_VALUE);
        this.button.setWrapText(true);
        this.button.setAlignment(Pos.CENTER);
        this.button.setTextAlignment(TextAlignment.CENTER);
        if (((BlankableValueControl)this.getSkinnable()).getSelected() != null) {
            this.button.setText(((BlankableValueControl)this.getSkinnable()).getSelected().getNameWithoutRating());
        }
    }

    private void initLayout() {
        this.button.setMinSize(100.0, 50.0);
        this.getChildren().add((Object)this.button);
    }

    private void initInteractivity() {
        ((BlankableValueControl)this.getSkinnable()).selected().addListener((ov, o, n) -> this.refresh());
        ((BlankableValueControl)this.getSkinnable()).controller().addListener((ov, o, n) -> {
            this.refresh();
            this.button.setOnAction(ev -> this.clicked());
        });
        this.button.setOnAction(ev -> {
            if (((BlankableValueControl)this.getSkinnable()).getController() != null) {
                ((BlankableValueControl)this.getSkinnable()).getController().selectClicked();
            }
        });
    }

    private void refresh() {
        Object selected = ((BlankableValueControl)this.getSkinnable()).getSelected();
        SingleComplexDataItemController ctrl = ((BlankableValueControl)this.getSkinnable()).getController();
        if (selected == null) {
            this.button.setGraphic(null);
            this.button.setStyle("-fx-border-insets: 0;\n-fx-border-width: 1;\n-fx-stroke-dashed-offset: 5;\n-fx-border-style: dashed;\n");
            this.button.setText(((BlankableValueControl)this.getSkinnable()).getPlaceholder());
            if (ctrl == null) {
                this.button.setDisable(true);
            } else {
                this.button.setDisable(!ctrl.canBeUsed());
            }
        } else {
            this.button.setGraphic((Node)this.icoDel);
            this.button.setStyle(null);
            this.button.setText(selected.getNameWithoutRating());
            if (ctrl == null) {
                this.button.setDisable(true);
            } else {
                this.button.setDisable(false);
            }
        }
    }

    private void clicked() {
        System.getLogger(((Object)((Object)this)).getClass().getPackageName()).log(System.Logger.Level.WARNING, "clicked");
        Object selected = ((BlankableValueControl)this.getSkinnable()).getSelected();
        SingleComplexDataItemController ctrl = ((BlankableValueControl)this.getSkinnable()).getController();
        System.getLogger(((Object)((Object)this)).getClass().getPackageName()).log(System.Logger.Level.WARNING, "ctrl " + String.valueOf(ctrl));
        if (ctrl == null) {
            return;
        }
        if (selected == null) {
            ctrl.selectClicked();
        } else {
            ctrl.deselect(selected);
            this.refresh();
        }
    }
}

