/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;
import org.prelle.javafx.Chip;
import org.prelle.javafx.Section;
import org.prelle.javafx.SymbolIcon;

public abstract class FlowSection<T>
extends Section {
    protected static final System.Logger logger = RPGFrameworkJavaFX.logger;
    protected Button btnAdd;
    protected FlowPane flow;
    protected ObjectProperty<T> showHelpFor = new SimpleObjectProperty();

    public FlowSection(String title) {
        super.setId(title);
        this.initListComponents();
        this.getStyleClass().add((Object)"list-section");
        this.setTitle(title);
        this.setContent((Node)this.flow);
        this.initListInteractivity();
    }

    private void initListComponents() {
        this.flow = new FlowPane(10.0, 10.0);
        this.flow.setMaxHeight(Double.MAX_VALUE);
        this.btnAdd = new Button(null, (Node)new SymbolIcon("add"));
        this.getButtons().addAll((Object[])new Button[]{this.btnAdd});
    }

    protected void initListInteractivity() {
        this.btnAdd.setOnAction(ev -> this.onAdd());
    }

    protected void selectionChanged(T old, T neu) {
    }

    public void setData(List<T> data) {
        this.flow.getChildren().clear();
        for (T item : data) {
            Chip chip = new Chip();
            chip.setText(String.valueOf(item));
            chip.setUserData(item);
            chip.setOnMouseClicked(ev -> this.showHelpFor.set(item));
            this.flow.getChildren().add((Object)chip);
        }
    }

    public ReadOnlyObjectProperty<T> showHelpForProperty() {
        return this.showHelpFor;
    }

    protected abstract void onAdd();

    protected abstract void onDelete(T var1);

    protected void onSettings() {
        logger.log(System.Logger.Level.WARNING, "onSettings() not overloaded in " + String.valueOf(((Object)((Object)this)).getClass()));
    }
}

