/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.skin;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.DataItemDetailsPane;
import de.rpgframework.jfx.DataItemPane;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.layout.ResponsiveBox;

public class DataItemPaneSkin<T extends DataItem>
extends SkinBase<DataItemPane<T>> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private DataItemDetailsPane<T> details;
    private ResponsiveBox layout;

    public DataItemPaneSkin(DataItemPane<T> control, Function<Requirement, String> req, Function<Modification, String> mod) {
        super(control);
        this.initComponents(req, mod);
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents(Function<Requirement, String> reqR, Function<Modification, String> modR) {
        this.details = new DataItemDetailsPane(reqR, modR);
        this.details.setMaxHeight(Double.MAX_VALUE);
        this.details.showModificationsInDescriptionProperty().bind((ObservableValue)((DataItemPane)this.getSkinnable()).showModificationsInDescriptionProperty());
    }

    private void initLayout() {
        this.layout = new ResponsiveBox();
        this.layout.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.reLayout();
        this.getChildren().add((Object)this.layout);
    }

    private void reLayout() {
        logger.log(System.Logger.Level.INFO, "reLayout=" + String.valueOf(ResponsiveControlManager.getCurrentMode()));
        this.layout.getChildren().clear();
        ListView regSpinner = ((DataItemPane)this.getSkinnable()).getSelectorNode();
        this.layout.getChildren().add((Object)regSpinner);
        this.layout.getChildren().add(this.details);
    }

    private void initInteractivity() {
        ((DataItemPane)this.getSkinnable()).selectorNodeProperty().addListener((ov, o, n) -> this.reLayout());
        this.details.selectedItemProperty().bind(((DataItemPane)this.getSkinnable()).selectedItemProperty());
        this.details.showDecisionColumnProperty().bind((ObservableValue)((DataItemPane)this.getSkinnable()).showDecisionColumnProperty());
        this.details.showStatsColumnProperty().bind((ObservableValue)((DataItemPane)this.getSkinnable()).showStatsColumnProperty());
        this.details.modificationConverterProperty().bind(((DataItemPane)this.getSkinnable()).modificationConverterProperty());
        this.details.referenceTypeConverterProperty().bind(((DataItemPane)this.getSkinnable()).referenceTypeConverterProperty());
        this.details.choiceConverterProperty().bind(((DataItemPane)this.getSkinnable()).choiceConverterProperty());
        ((DataItemPane)this.getSkinnable()).layoutModeProperty().addListener((ov, o, n) -> {
            logger.log(System.Logger.Level.INFO, "getSkinnable().layoutMode changed to " + String.valueOf(n));
            this.reLayout();
        });
        this.details.decisionHandlerProperty().bind(((DataItemPane)this.getSkinnable()).decisionHandlerProperty());
        this.details.modDecisionHandlerProperty().bind(((DataItemPane)this.getSkinnable()).modDecisionHandlerProperty());
        this.details.customNode1Property().bind(((DataItemPane)this.getSkinnable()).customNode1Property());
        ((DataItemPane)this.getSkinnable()).prefHeightProperty().addListener((ov, o, n) -> logger.log(System.Logger.Level.INFO, "Pref Height changed to " + String.valueOf(n)));
    }
}

