/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.wizard;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.genericrpg.chargen.CharacterGenerator;
import de.rpgframework.genericrpg.chargen.GeneratorId;
import de.rpgframework.genericrpg.chargen.IGeneratorWrapper;
import de.rpgframework.genericrpg.chargen.Rule;
import de.rpgframework.genericrpg.chargen.RuleInterpretation;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.jfx.wizard.CharacterGeneratorListCell;
import de.rpgframework.jfx.wizard.RuleChoiceBox;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.TitledComponent;
import org.prelle.javafx.WindowMode;
import org.prelle.javafx.Wizard;
import org.prelle.javafx.WizardPage;

public class WizardPageGenerator<A extends IAttribute, C extends RuleSpecificCharacterObject<A, ?, ?, ?>, G extends CharacterGenerator<A, C>>
extends WizardPage {
    private static final System.Logger logger = System.getLogger(WizardPageGenerator.class.getPackageName());
    private static PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle(WizardPageGenerator.class.getPackageName() + ".WizardPages");
    private List<Class<G>> allKnown;
    private Rule[] allRules;
    private IGeneratorWrapper<A, C, G> wrapper;
    private ChoiceBox<RuleInterpretation> cbStrictness;
    private ListView<Class<G>> options;
    private RuleChoiceBox bxRules;
    private Label descHeading;
    private Label description;
    private VBox bxExtraAndRules;
    private VBox descBox;
    private VBox layout;
    private Function<Class<G>, String[]> nameGetter;
    private ObjectProperty<Node> extraNode = new SimpleObjectProperty();
    private Class<G> selected;

    public WizardPageGenerator(Wizard wizard, IGeneratorWrapper<A, C, G> model, List<Class<G>> values, List<RuleInterpretation> interpretations, Rule[] allRules, Function<Class<G>, String[]> nameGetter) {
        super(wizard);
        this.allKnown = values;
        this.setTitle(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.generator.title"));
        this.wrapper = model;
        this.allRules = allRules;
        this.nameGetter = nameGetter;
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        String expect = Locale.getDefault().getLanguage();
        List filtered = interpretations.stream().filter(i -> i.getLanguage() == null || expect.equals(i.getLanguage())).collect(Collectors.toList());
        this.cbStrictness.getItems().setAll(filtered);
        this.cbStrictness.getSelectionModel().select(0);
        if (this.wrapper != null && this.wrapper.getModel() instanceof CommonCharacter) {
            String interID = ((CommonCharacter)this.wrapper.getModel()).getStrictness();
            for (RuleInterpretation inter : interpretations) {
                if (!inter.getId().equals(interID)) continue;
                this.cbStrictness.getSelectionModel().select((Object)inter);
                break;
            }
        }
        if (this.cbStrictness.getValue() != null) {
            logger.log(System.Logger.Level.INFO, "Start with strictness '" + ((RuleInterpretation)this.cbStrictness.getValue()).getId() + "'");
        }
        this.interpretationChanged();
        logger.log(System.Logger.Level.INFO, "CURRENT: " + String.valueOf(model.getWrapped()));
        if (!this.options.getItems().isEmpty()) {
            this.options.getSelectionModel().select((Object)model.getWrapped().getClass());
        }
    }

    private void initComponents() {
        this.cbStrictness = new ChoiceBox();
        this.cbStrictness.setConverter((StringConverter)new StringConverter<RuleInterpretation>(){

            public String toString(RuleInterpretation value) {
                return value != null ? value.getName() : ResourceI18N.get((ResourceBundle)RES, (String)"interpretation.label");
            }

            public RuleInterpretation fromString(String arg0) {
                return null;
            }
        });
        this.options = new ListView();
        this.options.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.options.setCellFactory(new Callback<ListView<Class<G>>, ListCell<Class<G>>>(){

            public ListCell<Class<G>> call(ListView<Class<G>> arg0) {
                return new CharacterGeneratorListCell(WizardPageGenerator.this.nameGetter);
            }
        });
        int lines = Math.max(4, this.options.getItems().size());
        this.options.setStyle("-fx-pref-width: 15em; -fx-pref-height: " + (double)lines * 3.5 + "em");
        this.bxRules = new RuleChoiceBox(Rule.EffectOn.CHARGEN, Rule.EffectOn.COMMON);
        this.descHeading = new Label();
        this.description = new Label();
        this.description.setWrapText(true);
    }

    private void initLayout() {
        this.descBox = new VBox(20.0);
        this.descBox.getChildren().addAll((Object[])new Node[]{this.descHeading, this.description});
        this.description.setStyle("-fx-pref-width: 18em");
        this.layout = new VBox();
        super.setContent((Node)this.layout);
        this.bxExtraAndRules = new VBox(new Node[]{this.bxRules});
        if (this.extraNode.get() != null) {
            this.bxExtraAndRules.getChildren().add(0, (Object)((Node)this.extraNode.get()));
        }
        super.setBackContent((Node)this.bxExtraAndRules);
        this.updateLayout();
    }

    private void updateLayout() {
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "ENTER updateLayout(" + String.valueOf(ResponsiveControlManager.getCurrentMode()) + ")");
        }
        logger.log(System.Logger.Level.WARNING, "ENTER updateLayout(" + String.valueOf(ResponsiveControlManager.getCurrentMode()) + ")");
        this.layout.getChildren().clear();
        this.bxExtraAndRules.getChildren().retainAll((Object[])new Node[]{this.bxRules});
        if (this.extraNode.get() != null) {
            this.bxExtraAndRules.getChildren().add(0, (Object)((Node)this.extraNode.get()));
        }
        this.layout.getChildren().addAll((Object[])new Node[]{this.options, this.descBox});
        TitledComponent tcStrict = new TitledComponent(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.generator.interpretation.label"), this.cbStrictness);
        VBox bxList = new VBox(5.0, new Node[]{tcStrict, this.options});
        this.options.setMaxHeight(Double.MAX_VALUE);
        bxList.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.options, (Priority)Priority.ALWAYS);
        Label lbFineTune = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.generator.backheader.finetune"));
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        HBox backHeader = new HBox(10.0, new Node[]{lbFineTune, buf, new SymbolIcon("setting")});
        HBox.setHgrow((Node)buf, (Priority)Priority.ALWAYS);
        backHeader.setMaxWidth(Double.MAX_VALUE);
        HBox.setMargin((Node)lbFineTune, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        HBox.setMargin((Node)((Node)backHeader.getChildren().get(2)), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        switch (ResponsiveControlManager.getCurrentMode()) {
            case MINIMAL: {
                super.setBackHeader((Node)backHeader);
                VBox helpV = new VBox(20.0, new Node[]{bxList, this.descBox});
                helpV.setAlignment(Pos.TOP_LEFT);
                VBox.setVgrow((Node)bxList, (Priority)Priority.ALWAYS);
                VBox.setVgrow((Node)this.descBox, (Priority)Priority.ALWAYS);
                this.bxRules.setStyle("-fx-pref-width: 23em; -fx-min-height: 15em");
                bxList.setStyle("-fx-pref-height: 14em");
                this.layout.getChildren().add((Object)helpV);
                break;
            }
            default: {
                HBox helpH = new HBox(20.0, new Node[]{bxList, this.descBox});
                helpH.setMaxHeight(Double.MAX_VALUE);
                VBox.setVgrow((Node)helpH, (Priority)Priority.ALWAYS);
                if (ResponsiveControlManager.getCurrentMode() == WindowMode.EXPANDED) {
                    super.setBackContent(null);
                    super.setBackHeader(null);
                    this.bxRules.setMaxHeight(Double.MAX_VALUE);
                    this.bxExtraAndRules.setMaxHeight(Double.MAX_VALUE);
                    helpH.setFillHeight(true);
                    helpH.getChildren().add(1, (Object)this.bxExtraAndRules);
                    HBox.setHgrow((Node)this.bxRules, (Priority)Priority.SOMETIMES);
                } else {
                    super.setBackContent((Node)this.bxExtraAndRules);
                    super.setBackHeader((Node)backHeader);
                }
                this.bxRules.setStyle("-fx-pref-width: 30em; -fx-max-width: 40em");
                bxList.setStyle("-fx-pref-height: 20em");
                this.layout.getChildren().add((Object)helpH);
            }
        }
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "LEAVE updateLayout(" + String.valueOf(ResponsiveControlManager.getCurrentMode()) + ")");
        }
    }

    private void initStyle() {
        this.descHeading.getStyleClass().add((Object)"text-small-subheader");
        this.description.getStyleClass().add((Object)"text-body");
    }

    private void initInteractivity() {
        this.options.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<Class<G>>(){

            public void changed(ObservableValue<? extends Class<G>> observable, Class<G> oldValue, Class<G> newValue) {
                if (newValue != null) {
                    logger.log(System.Logger.Level.DEBUG, "selected " + String.valueOf(newValue));
                    WizardPageGenerator.this.descHeading.setText(WizardPageGenerator.this.nameGetter.apply(newValue)[0]);
                    WizardPageGenerator.this.description.setText(WizardPageGenerator.this.nameGetter.apply(newValue)[1]);
                } else {
                    WizardPageGenerator.this.descHeading.setText(null);
                    WizardPageGenerator.this.description.setText(null);
                }
                WizardPageGenerator.this.selectGenerator(newValue);
            }
        });
        this.cbStrictness.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.interpretationChanged());
        this.extraNode.addListener((ov, o, n) -> this.updateLayout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpretationChanged() {
        RuleInterpretation n = (RuleInterpretation)this.cbStrictness.getValue();
        try {
            logger.log(System.Logger.Level.ERROR, "ENTER: interpretationChanged  (" + String.valueOf(n) + ")");
            if (n != null && this.wrapper != null && this.wrapper.getModel() instanceof CommonCharacter) {
                ((CommonCharacter)this.wrapper.getModel()).setStrictness(n.getId());
                this.wrapper.getRuleController().updateEffectiveRules();
            }
            Class current = (Class)this.options.getSelectionModel().getSelectedItem();
            List<Class<Object>> toSet = new ArrayList<Class<G>>(this.allKnown);
            if (this.wrapper != null) {
                this.bxRules.setData((CharacterController<?, ?>)this.wrapper);
                if (n != null && n.getRestrictGenTo() != null) {
                    logger.log(System.Logger.Level.DEBUG, "CharGens are restricted");
                    toSet = toSet.stream().filter(r -> {
                        logger.log(System.Logger.Level.ERROR, "Check {0}", r);
                        try {
                            GeneratorId anno = r.getAnnotation(GeneratorId.class);
                            String id = null;
                            if (anno == null) {
                                logger.log(System.Logger.Level.WARNING, String.valueOf(r) + " is missing @GeneratorId - now I need to instantiate it to obtain the ID");
                                System.err.println(String.valueOf(r) + " is missing @GeneratorId - now I need to instantiate it to obtain the ID");
                                id = ((CharacterGenerator)r.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getId();
                            } else {
                                id = anno.value();
                            }
                            logger.log(System.Logger.Level.ERROR, "Is {0} in {1} = {2}", id, n.getRestrictGenTo(), n.getRestrictGenTo().contains(id));
                            return n.getRestrictGenTo().contains(id);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            e.printStackTrace();
                            return true;
                        }
                    }).collect(Collectors.toList());
                }
                logger.log(System.Logger.Level.ERROR, "Allowed chargens: " + String.valueOf(toSet));
                this.options.getItems().setAll(toSet);
            }
            if (current != null && toSet.contains(current)) {
                this.options.getSelectionModel().select((Object)current);
            } else if (!toSet.isEmpty()) {
                this.options.getSelectionModel().select((Object)((Class)toSet.get(0)));
            }
        }
        finally {
            if (logger.isLoggable(System.Logger.Level.TRACE)) {
                logger.log(System.Logger.Level.TRACE, "LEAVE: interpretationChanged");
            }
        }
    }

    public void setResponsiveMode(WindowMode value) {
        logger.log(System.Logger.Level.WARNING, "ENTER setResponsiveMode(" + String.valueOf(value) + ")");
        this.updateLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectGenerator(Class<G> clazz) {
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "ENTER selectGenerator(" + String.valueOf(clazz) + ")");
        }
        try {
            if (clazz == null) {
                return;
            }
            Class currentlyUsed = null;
            if (this.wrapper != null && this.wrapper.getWrapped() != null) {
                currentlyUsed = this.wrapper.getWrapped().getClass();
            }
            logger.log(System.Logger.Level.INFO, "currentlyUsed " + String.valueOf(currentlyUsed));
            logger.log(System.Logger.Level.INFO, "Change generator to " + String.valueOf(clazz));
            try {
                this.selected = clazz;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed instantiating new generator " + String.valueOf(clazz), (Throwable)e);
                this.descHeading.setText(null);
                this.description.setText(null);
            }
        }
        finally {
            if (logger.isLoggable(System.Logger.Level.TRACE)) {
                logger.log(System.Logger.Level.TRACE, "LEAVE selectGenerator(" + String.valueOf(clazz) + ")");
            }
        }
    }

    public void pageVisited() {
        logger.log(System.Logger.Level.DEBUG, "pageVisited: " + String.valueOf(this.wrapper.getWrapped()));
        logger.log(System.Logger.Level.DEBUG, "selection is " + String.valueOf(this.options.getSelectionModel().getSelectedItem()));
        if (this.wrapper.getWrapped() != null && this.options.getSelectionModel().getSelectedItem() != this.wrapper.getWrapped().getClass()) {
            this.options.getSelectionModel().select((Object)this.wrapper.getWrapped().getClass());
        }
    }

    public void pageLeft() {
        if (this.wrapper.getModel() instanceof CommonCharacter) {
            logger.log(System.Logger.Level.INFO, "Set chargen used to {0}", this.wrapper.getId());
            ((CommonCharacter)this.wrapper.getModel()).setCharGenUsed(this.wrapper.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeLeaving() {
        block8: {
            block9: {
                logger.log(System.Logger.Level.DEBUG, "beforeLeaving");
                logger.log(System.Logger.Level.DEBUG, "..instance={0}", this.wrapper.getWrapped());
                logger.log(System.Logger.Level.DEBUG, "..selected={0}", this.selected);
                logger.log(System.Logger.Level.DEBUG, "..condition1 {0}", this.selected != null);
                logger.log(System.Logger.Level.DEBUG, "..condition2 {0}", this.wrapper.getWrapped().getClass() != this.selected);
                if (this.selected == null || this.wrapper.getWrapped() != null && this.wrapper.getWrapped().getClass() == this.selected) break block9;
                logger.log(System.Logger.Level.INFO, "Instantiate {0}  (previous {1})", this.selected, this.wrapper.getWrapped().getClass());
                CharacterGenerator newGen = null;
                try {
                    Constructor<G> cons = this.selected.getConstructor(RuleSpecificCharacterObject.class, CharacterHandle.class);
                    newGen = (CharacterGenerator)cons.newInstance(this.wrapper.getModel(), null);
                }
                catch (Exception e1) {
                    logger.log(System.Logger.Level.ERROR, "Expected constructor " + this.selected.getSimpleName() + "<init>(RulespecificCHaracterObject, CharacterHandle)");
                    try {
                        Constructor<G> cons = this.selected.getConstructor(new Class[0]);
                        newGen = (CharacterGenerator)cons.newInstance(new Object[0]);
                        newGen.setModel(this.wrapper.getModel(), null);
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Problem finding constructor");
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                this.newCharGenCreated(newGen, this.wrapper.getModel());
                try {
                    this.wrapper.setWrapped(newGen);
                    logger.log(System.Logger.Level.DEBUG, "call runProcessors on " + String.valueOf(newGen));
                    newGen.runProcessors();
                }
                catch (Exception e) {
                    try {
                        logger.log(System.Logger.Level.ERROR, "Failed instantiating " + String.valueOf(this.selected), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        logger.log(System.Logger.Level.INFO, "Instantiate {0} finished", this.selected);
                        throw throwable;
                    }
                    logger.log(System.Logger.Level.INFO, "Instantiate {0} finished", this.selected);
                    break block8;
                }
                logger.log(System.Logger.Level.INFO, "Instantiate {0} finished", this.selected);
                break block8;
            }
            this.wrapper.runProcessors();
        }
    }

    protected void newCharGenCreated(G newGen, C model) {
    }

    public ObjectProperty<Node> extraNode() {
        return this.extraNode();
    }

    public Node getExtraNode() {
        return (Node)this.extraNode.get();
    }

    public WizardPageGenerator setExtraNode(Node value) {
        this.extraNode.set((Object)value);
        return this;
    }
}

