/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.core.CustomResourceManagerLoader;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.PageReference;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.attach.PDFViewerServiceFactory;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;

public abstract class ADescriptionPane<T extends DataItem>
extends VBox {
    private static final ResourceBundle RES = ResourceBundle.getBundle(GenericDescriptionVBox.class.getName());
    protected BooleanProperty useScrollPane = new SimpleBooleanProperty(true);
    protected Label descTitle;
    protected Label descSources;
    private T item;
    protected TextFlow description;
    private TextField tfKey;
    private TextArea taDescr;
    protected VBox inner;

    protected ADescriptionPane() {
        this.getStyleClass().add((Object)"description-pane");
        this.initComponents();
        this.initExtraComponents();
        this.initLayout();
        this.initExtraLayout();
        this.initInteractivity();
        this.taDescr.setVisible(false);
        this.taDescr.setManaged(false);
    }

    private final void initComponents() {
        this.descTitle = new Label("");
        this.descTitle.setWrapText(true);
        this.descTitle.getStyleClass().add((Object)"title");
        this.descSources = new Label("");
        this.descSources.setWrapText(true);
        this.description = new TextFlow();
        this.taDescr = new TextArea();
        this.tfKey = new TextField();
        this.tfKey.setVisible(false);
        this.tfKey.setManaged(false);
    }

    protected void initExtraComponents() {
    }

    protected final void initLayout() {
        Label hdDescription = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.descr"));
        hdDescription.getStyleClass().add((Object)"base");
        this.inner = new VBox(5.0, new Node[]{hdDescription, this.description, this.tfKey, this.taDescr});
        this.setMaxHeight(Double.MAX_VALUE);
        this.setStyle("-fx-pref-width: 20em");
        this.setStyle("-fx-max-width: 30em");
        this.getChildren().addAll((Object[])new Node[]{this.descTitle, this.descSources, this.getWithOrWithoutScrollPane()});
    }

    protected void initExtraLayout() {
    }

    private Node getWithOrWithoutScrollPane() {
        if (this.useScrollPane.get()) {
            ScrollPane scroll = new ScrollPane((Node)this.inner);
            scroll.setFitToWidth(true);
            scroll.setMinHeight(200.0);
            scroll.setMaxHeight(Double.MAX_VALUE);
            VBox.setVgrow((Node)scroll, (Priority)Priority.ALWAYS);
            return scroll;
        }
        return this.inner;
    }

    protected void initInteractivity() {
        this.useScrollPaneProperty().addListener((ov, o, n) -> this.getChildren().setAll((Object[])new Node[]{this.descTitle, this.descSources, this.getWithOrWithoutScrollPane()}));
        this.description.setOnMouseEntered(ev -> this.enterDescription());
        this.taDescr.setOnMouseExited(ev -> this.exitDescription());
        this.taDescr.textProperty().addListener((ov, o, n) -> this.customDescriptionChanged((DataItem)this.item, (String)n));
    }

    public BooleanProperty useScrollPaneProperty() {
        return this.useScrollPane;
    }

    public Boolean isUseScrollPane() {
        return this.useScrollPane.get();
    }

    public ADescriptionPane<T> setUseScrollPane(Boolean value) {
        this.useScrollPane.set(value.booleanValue());
        return this;
    }

    public void setData(String title, String source, String desc) {
        this.descTitle.setText(title);
        this.descSources.setText(source);
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, desc);
    }

    public void setData(T data) {
        PageReference pageRef;
        this.item = data;
        if (data == null) {
            this.descTitle.setText(null);
            this.descSources.setText(null);
            this.description.getChildren().clear();
            return;
        }
        Optional<PageReference> optPageRef = data.getPageReferences().stream().filter(pr -> pr.getLanguage().equals(Locale.getDefault().getLanguage())).findFirst();
        PageReference pageReference = pageRef = optPageRef.isPresent() ? optPageRef.get() : null;
        if (pageRef != null) {
            PDFViewerServiceFactory.create().ifPresent(service -> service.show(pageRef.getProduct().getRules(), pageRef.getProduct().getID(), pageRef.getLanguage(), pageRef.getPage()));
        }
        this.descTitle.setText(data.getName(Locale.getDefault()));
        this.descSources.setText(RPGFrameworkJavaFX.createSourceText(data));
        this.tfKey.setVisible(!data.hasLicense(Locale.getDefault()));
        this.tfKey.setManaged(!data.hasLicense(Locale.getDefault()));
        this.tfKey.setText(data.getTypeString() + "." + data.getId().toLowerCase() + ".desc");
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, data.getDescription(Locale.getDefault()));
        if (CustomResourceManagerLoader.getInstance() != null) {
            DataSet set = this.item.getFirstParent(Locale.getDefault());
            String key = this.item.getTypeString() + "." + this.item.getId().toLowerCase() + ".desc";
            String custom = CustomResourceManagerLoader.getInstance().getProperty(set.getRules(), key, Locale.getDefault());
            this.taDescr.setText(custom);
        }
    }

    public void setTitle(String title) {
        this.descTitle.setText(title);
    }

    public void setSources(String value) {
        this.descSources.setText(value);
    }

    private void enterDescription() {
        this.description.setVisible(false);
        this.description.setManaged(false);
        this.tfKey.setVisible(false);
        this.tfKey.setManaged(false);
        this.taDescr.setVisible(true);
        this.taDescr.setManaged(true);
    }

    private void exitDescription() {
        this.description.setVisible(true);
        this.description.setManaged(true);
        this.tfKey.setVisible(true);
        this.tfKey.setManaged(true);
        this.taDescr.setVisible(false);
        this.taDescr.setManaged(false);
    }

    private void customDescriptionChanged(DataItem item, String text) {
        if (text == null || text.isBlank()) {
            return;
        }
        System.getLogger(((Object)((Object)this)).getClass().getPackageName()).log(System.Logger.Level.INFO, "customDescriptionChanged");
        if (item == null) {
            return;
        }
        String key = item.getTypeString() + "." + item.getId().toLowerCase() + ".desc";
        item.getDescription(Locale.getDefault());
        text = text.replaceAll("\n", "<br/>");
        if (CustomResourceManagerLoader.getInstance() != null) {
            DataSet set = item.getFirstParent(Locale.getDefault());
            CustomResourceManagerLoader.getInstance().setProperty(set.getRules(), key, Locale.getDefault(), text);
        }
        if (text != null && !text.isBlank()) {
            RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, text);
        }
    }
}

