/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.CharacterProvider;
import de.rpgframework.character.CharacterProviderLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.prelle.javafx.AcrylicStackPane;
import org.prelle.javafx.SymbolIcon;

public class CharacterHandleBox
extends AcrylicStackPane {
    private static final ResourceBundle RES = ResourceBundle.getBundle(CharacterHandleBox.class.getName());
    public static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private CharacterHandle handle;
    private ImageView iView;
    private Label lbName;
    private Label lbDescription;
    private Button btnOpen;
    private Button btnDelete;
    private Button btnExport;
    private Button btnOpenDir;
    private HBox layout;
    private Label mode;

    public CharacterHandleBox() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.iView = new ImageView();
        this.iView.setFitWidth(96.0);
        this.iView.setFitHeight(96.0);
        this.iView.setImage(new Image(CharacterHandleBox.class.getResourceAsStream("Person.png")));
        this.lbName = new Label("Empty");
        this.lbName.getStyleClass().add((Object)"subtitle");
        this.lbDescription = new Label("Empty");
        this.lbDescription.getStyleClass().add((Object)"text-secondary-info");
        this.btnOpen = new Button(null, (Node)new SymbolIcon("edit"));
        this.btnOpen.getStyleClass().add((Object)"app-bar-button");
        this.btnOpen.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"tooltip.open")));
        this.btnDelete = new Button(null, (Node)new SymbolIcon("delete"));
        this.btnDelete.getStyleClass().add((Object)"app-bar-button");
        this.btnDelete.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"tooltip.delete")));
        this.btnExport = new Button(null, (Node)new SymbolIcon("print"));
        this.btnExport.getStyleClass().add((Object)"app-bar-button");
        this.btnExport.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"tooltip.export")));
        this.btnOpenDir = new Button(null, (Node)new SymbolIcon("folder"));
        this.btnOpenDir.getStyleClass().add((Object)"app-bar-button");
        this.btnOpenDir.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"tooltip.openDir")));
        if ("android".equals(System.getProperty("javafx.platform"))) {
            this.btnOpenDir.setVisible(false);
        }
    }

    private void initLayout() {
        this.layout = new HBox(10.0);
        Region spacing = new Region();
        spacing.setMaxWidth(Double.MAX_VALUE);
        HBox bxActions = new HBox(new Node[]{this.btnOpen, this.btnExport, this.btnOpenDir, spacing, this.btnDelete});
        HBox.setHgrow((Node)spacing, (Priority)Priority.ALWAYS);
        Separator sep = new Separator(Orientation.HORIZONTAL);
        Region buf = new Region();
        buf.setMaxHeight(Double.MAX_VALUE);
        VBox content = new VBox(new Node[]{this.lbName, this.lbDescription, buf, sep, bxActions});
        VBox.setVgrow((Node)buf, (Priority)Priority.ALWAYS);
        this.layout.getChildren().addAll((Object[])new Node[]{this.iView, content});
        HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        content.setMaxWidth(Double.MAX_VALUE);
        content.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.layout);
        this.mode = new Label("?");
        this.mode.getStyleClass().add((Object)"mini-button");
        this.mode.setStyle("-fx-text-fill: highlight; -fx-font-size: 200%; ");
        this.getChildren().add((Object)this.mode);
        StackPane.setAlignment((Node)this.mode, (Pos)Pos.TOP_RIGHT);
        this.setMaxWidth(330.0);
        this.setMaxHeight(96.0);
    }

    private void initInteractivity() {
        this.btnDelete.setOnAction(ev -> logger.log(System.Logger.Level.INFO, "Delete"));
    }

    public void setOnDelete(EventHandler<ActionEvent> handler) {
        this.btnDelete.setOnAction(handler);
    }

    public void setOnOpen(EventHandler<ActionEvent> handler) {
        this.btnOpen.setOnAction(handler);
    }

    public void setOnExport(EventHandler<ActionEvent> handler) {
        this.btnExport.setOnAction(handler);
    }

    public void setOnOpenDir(EventHandler<ActionEvent> handler) {
        this.btnOpenDir.setOnAction(handler);
    }

    public void setImage(Image image) {
        this.iView.setImage(image);
    }

    public void setHandle(CharacterHandle value) {
        this.handle = value;
        this.lbName.setText(value.getName());
        this.lbDescription.setText(value.getShortDescription());
        CharacterProvider prov = CharacterProviderLoader.getCharacterProvider();
        byte[] imageBytes = null;
        try {
            Attachment attach = prov.getFirstAttachment(value, Attachment.Type.CHARACTER, Attachment.Format.IMAGE);
            if (attach != null) {
                imageBytes = attach.getData();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed loading image attachment", (Throwable)e);
        }
        if (imageBytes == null) {
            this.iView.setImage(new Image(CharacterHandleBox.class.getResourceAsStream("Person.png")));
        } else {
            this.iView.setImage(new Image((InputStream)new ByteArrayInputStream(imageBytes)));
        }
        if (this.handle.getCharacter() != null) {
            this.mode.setText(this.handle.getCharacter().isInCareerMode() ? "\ud83d\udcb9" : "\ud83d\udc76");
            this.mode.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)(this.handle.getCharacter().isInCareerMode() ? "tooltip.career" : "tooltip.chargen"))));
            this.btnExport.setVisible(true);
        } else {
            this.btnExport.setVisible(false);
        }
    }
}

