/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.jfx.skin.FuturisticBorderElementSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FuturisticBorderElement
extends Control {
    private static final int DEFAULT_DECO_WIDTH = -10;
    @FXML
    private DoubleProperty borderWidth;
    @FXML
    private DoubleProperty borderWidthTop;
    @FXML
    private DoubleProperty borderWidthBottom;
    @FXML
    private DoubleProperty borderWidthLeft;
    @FXML
    private DoubleProperty borderWidthRight;
    @FXML
    private BooleanProperty innerBorder;
    @FXML
    private ObjectProperty<Paint> borderColor;
    @FXML
    private ObjectProperty<Node> content = new SimpleObjectProperty();

    public FuturisticBorderElement() {
    }

    public FuturisticBorderElement(Node content) {
        this.content.set((Object)content);
    }

    public FuturisticBorderElement(Node content, int width) {
        this.content.set((Object)content);
        this.setBorderWidthBottom(width);
        this.setBorderWidthTop(width);
        this.setBorderWidthLeft(width);
        this.setBorderWidthRight(width);
    }

    public FuturisticBorderElement(Node content, int decoTop, int decoLeft, int decoBottom, int decoRight) {
        this.content.set((Object)content);
        this.setBorderWidthBottom(decoBottom);
        this.setBorderWidthTop(decoTop);
        this.setBorderWidthLeft(decoLeft);
        this.setBorderWidthRight(decoRight);
    }

    public Skin<?> createDefaultSkin() {
        return new FuturisticBorderElementSkin(this);
    }

    public final void setContent(Node value) {
        this.contentProperty().set((Object)value);
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setBorderColor(Paint value) {
        this.borderColorProperty().set((Object)value);
    }

    public final Paint getBorderColor() {
        return this.borderColor == null ? Color.BLACK : (Paint)this.borderColor.get();
    }

    public final ObjectProperty<Paint> borderColorProperty() {
        if (this.borderColor == null) {
            this.borderColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData<FuturisticBorderElement, Paint> getCssMetaData() {
                    return StyleableProperties.BORDER_COLOR;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderColor";
                }
            };
        }
        return this.borderColor;
    }

    public final void setBorderWidth(int value) {
        this.borderWidthProperty().set((double)value);
    }

    public final double getBorderWidth() {
        return this.borderWidth == null ? -10.0 : this.borderWidth.get();
    }

    public final DoubleProperty borderWidthProperty() {
        if (this.borderWidth == null) {
            this.borderWidth = new StyleableDoubleProperty(1.0){

                public CssMetaData<FuturisticBorderElement, Number> getCssMetaData() {
                    return StyleableProperties.BORDER_WIDTH;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderWidth";
                }
            };
        }
        return this.borderWidth;
    }

    public final void setBorderWidthTop(int value) {
        this.borderWidthTopProperty().set((double)value);
    }

    public final double getBorderWidthTop() {
        return this.borderWidthTop == null ? -10.0 : this.borderWidthTop.get();
    }

    public final DoubleProperty borderWidthTopProperty() {
        if (this.borderWidthTop == null) {
            this.borderWidthTop = new StyleableDoubleProperty(0.0){

                public CssMetaData<FuturisticBorderElement, Number> getCssMetaData() {
                    return StyleableProperties.BORDER_WIDTH_TOP;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderWidthTop";
                }
            };
        }
        return this.borderWidthTop;
    }

    public final void setBorderWidthBottom(int value) {
        this.borderWidthBottomProperty().set((double)value);
    }

    public final double getBorderWidthBottom() {
        return this.borderWidthBottom == null ? -10.0 : this.borderWidthBottom.get();
    }

    public final DoubleProperty borderWidthBottomProperty() {
        if (this.borderWidthBottom == null) {
            this.borderWidthBottom = new StyleableDoubleProperty(0.0){

                public CssMetaData<FuturisticBorderElement, Number> getCssMetaData() {
                    return StyleableProperties.BORDER_WIDTH_BOTTOM;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderWidthBottom";
                }
            };
        }
        return this.borderWidthBottom;
    }

    public final void setBorderWidthLeft(int value) {
        this.borderWidthLeftProperty().set((double)value);
    }

    public final double getBorderWidthLeft() {
        return this.borderWidthLeft == null ? -10.0 : this.borderWidthLeft.get();
    }

    public final DoubleProperty borderWidthLeftProperty() {
        if (this.borderWidthLeft == null) {
            this.borderWidthLeft = new StyleableDoubleProperty(0.0){

                public CssMetaData<FuturisticBorderElement, Number> getCssMetaData() {
                    return StyleableProperties.BORDER_WIDTH_LEFT;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderWidthLeft";
                }
            };
        }
        return this.borderWidthLeft;
    }

    public final void setBorderWidthRight(int value) {
        this.borderWidthRightProperty().set((double)value);
    }

    public final double getBorderWidthRight() {
        return this.borderWidthRight == null ? -10.0 : this.borderWidthRight.get();
    }

    public final DoubleProperty borderWidthRightProperty() {
        if (this.borderWidthRight == null) {
            this.borderWidthRight = new StyleableDoubleProperty(0.0){

                public CssMetaData<FuturisticBorderElement, Number> getCssMetaData() {
                    return StyleableProperties.BORDER_WIDTH_RIGHT;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderWidthRight";
                }
            };
        }
        return this.borderWidthRight;
    }

    public final void setInnerBorder(boolean value) {
        this.innerBorderProperty().set(value);
    }

    public final boolean isInnerBorder() {
        return this.innerBorder == null ? false : this.innerBorder.get();
    }

    public final BooleanProperty innerBorderProperty() {
        if (this.innerBorder == null) {
            this.innerBorder = new StyleableBooleanProperty(false){

                public CssMetaData<FuturisticBorderElement, Boolean> getCssMetaData() {
                    return StyleableProperties.BORDER_INNER;
                }

                public Object getBean() {
                    return FuturisticBorderElement.this;
                }

                public String getName() {
                    return "borderInner";
                }
            };
        }
        return this.innerBorder;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<FuturisticBorderElement, Paint> BORDER_COLOR = new CssMetaData<FuturisticBorderElement, Paint>("-fx-border-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderColor == null || !n.borderColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderColorProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Number> BORDER_WIDTH = new CssMetaData<FuturisticBorderElement, Number>("-fx-border-width", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderWidth == null || !n.borderWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderWidthProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Number> BORDER_WIDTH_TOP = new CssMetaData<FuturisticBorderElement, Number>("-fx-border-width-top", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderWidthTop == null || !n.borderWidthTop.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderWidthTopProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Number> BORDER_WIDTH_BOTTOM = new CssMetaData<FuturisticBorderElement, Number>("-fx-border-width-bottom", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderWidthBottom == null || !n.borderWidthBottom.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderWidthBottomProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Number> BORDER_WIDTH_LEFT = new CssMetaData<FuturisticBorderElement, Number>("-fx-border-width-left", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderWidthLeft == null || !n.borderWidthLeft.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderWidthLeftProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Number> BORDER_WIDTH_RIGHT = new CssMetaData<FuturisticBorderElement, Number>("-fx-border-width-right", SizeConverter.getInstance(), (Number)0){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderWidthRight == null || !n.borderWidthRight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.borderWidthRightProperty();
            }
        };
        private static final CssMetaData<FuturisticBorderElement, Boolean> BORDER_INNER = new CssMetaData<FuturisticBorderElement, Boolean>("-fx-border-inner", BooleanConverter.getInstance(), Boolean.FALSE){

            public boolean isSettable(FuturisticBorderElement n) {
                return n.innerBorder == null || !n.innerBorder.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty)n.innerBorderProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, BORDER_COLOR, BORDER_WIDTH, BORDER_WIDTH_TOP, BORDER_WIDTH_BOTTOM, BORDER_WIDTH_LEFT, BORDER_WIDTH_RIGHT, BORDER_INNER);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

