/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.chargen.RecommendingController;
import de.rpgframework.genericrpg.data.DataItem;
import java.util.Locale;
import javafx.util.Callback;

public class RecommendationStateNameConverter<D extends DataItem>
implements Callback<D, String> {
    private RecommendingController<D> ctrl;

    public RecommendationStateNameConverter(RecommendingController<D> ctrl) {
        this.ctrl = ctrl;
    }

    protected String getBaseName(D data) {
        if (data == null) {
            return "-";
        }
        return data.getName(Locale.getDefault());
    }

    public String call(D data) {
        String name = this.getBaseName(data);
        RecommendationState state = this.ctrl.getRecommendationState(data);
        if (state == null) {
            return data.getName(Locale.getDefault());
        }
        switch (state) {
            case STRONGLY_RECOMMENDED: {
                return name + " \ue113";
            }
            case RECOMMENDED: {
                return name + " \ue1ce";
            }
            case UNRECOMMENDED: {
                return name + " \ue15b";
            }
        }
        return name;
    }
}

