/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ValueModification;
import de.rpgframework.jfx.DistributeModificationCell;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.ResultModificationCell;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.NavigButtonControl;

public class UserDistributeDialog
extends ManagedDialog {
    public static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private static PropertyResourceBundle UI = RPGFrameworkJFXConstants.UI;
    private DataItem decideFor;
    private Choice choice;
    private Parent content;
    private Label label;
    private ListView<Integer> distView;
    private ListView<ValueModification> modView;
    private ListView<ValueModification> resultView;
    private Button btnCombine;
    private NavigButtonControl buttonControl;

    public UserDistributeDialog(DataItem decideFor, Choice choice) {
        super(ResourceI18N.get((ResourceBundle)UI, (String)"wizard.selectMod.distribute"), null, new CloseType[]{CloseType.OK});
        this.decideFor = decideFor;
        if (choice.getDistribute() == null || choice.getDistribute().length == 0) {
            throw new IllegalArgumentException("No points to distribute in choice");
        }
        this.choice = choice;
        this.initComponents(decideFor.getName());
        this.initLayout();
        this.initInteractivity();
        this.buttonControl = new NavigButtonControl();
        this.buttonControl.setDisabled(CloseType.OK, true);
    }

    private void initComponents(String choiceReason) {
        this.distView = new ListView();
        this.modView = new ListView();
        this.resultView = new ListView();
        this.distView.getItems().addAll(List.of(this.choice.getDistribute()));
        ArrayList<ValueModification> mods = new ArrayList<ValueModification>();
        for (String key : this.choice.getChoiceOptions()) {
            mods.add(new ValueModification(this.choice.getChooseFrom(), key, 0));
        }
        this.modView.getItems().addAll(mods);
        this.modView.getStyleClass().add((Object)"bordered");
        this.distView.getStyleClass().add((Object)"bordered");
        this.resultView.getStyleClass().add((Object)"bordered");
        this.modView.setCellFactory((Callback)new Callback<ListView<ValueModification>, ListCell<ValueModification>>(){

            public ListCell<ValueModification> call(ListView<ValueModification> list) {
                return new DistributeModificationCell();
            }
        });
        this.resultView.setCellFactory((Callback)new Callback<ListView<ValueModification>, ListCell<ValueModification>>(){

            public ListCell<ValueModification> call(ListView<ValueModification> list) {
                return new ResultModificationCell();
            }
        });
        this.btnCombine = new Button(ResourceI18N.get((ResourceBundle)UI, (String)"button.combine"));
        this.btnCombine.getStyleClass().add((Object)"bordered");
        this.canBeCombined();
        this.label = new Label(choiceReason);
        this.label.getStyleClass().add((Object)"wizard-heading");
    }

    private void initLayout() {
        this.modView.setStyle("-fx-pref-width: 13em; -fx-pref-height: 10em;");
        this.distView.setStyle("-fx-pref-width: 6em; -fx-pref-height: 10em;");
        this.resultView.setStyle("-fx-max-width: 28.4em; -fx-pref-height: 10em;");
        HBox bxLTR = new HBox(20.0);
        bxLTR.getChildren().addAll((Object[])new Node[]{this.modView, this.btnCombine, this.distView});
        bxLTR.setAlignment(Pos.CENTER_LEFT);
        VBox content = new VBox(20.0);
        content.getChildren().addAll((Object[])new Node[]{this.label, bxLTR, this.resultView});
        BorderPane.setMargin(this.resultView, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        this.resultView.prefWidthProperty().bind((ObservableValue)bxLTR.widthProperty());
        this.setTitle(ResourceI18N.get((ResourceBundle)UI, (String)"wizard.selectMod.distribute"));
        this.setContent((Node)content);
    }

    private void initInteractivity() {
        this.btnCombine.setOnAction(event -> this.combine());
        this.modView.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.canBeCombined());
        this.distView.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.canBeCombined());
    }

    public NavigButtonControl getButtonControl() {
        return this.buttonControl;
    }

    public ValueModification[] getChoice() {
        Object[] ret = new ValueModification[this.choice.getDistribute().length];
        ret = (ValueModification[])this.resultView.getItems().toArray(ret);
        return ret;
    }

    private void canBeCombined() {
        this.btnCombine.setDisable(this.modView.getSelectionModel().getSelectedItem() == null || this.distView.getSelectionModel().getSelectedItem() == null);
    }

    private void combine() {
        Modification mod = (Modification)this.modView.getSelectionModel().getSelectedItem();
        Integer value = (Integer)this.distView.getSelectionModel().getSelectedItem();
        logger.log(System.Logger.Level.DEBUG, "Combine " + String.valueOf(mod) + " with " + value);
        if (mod instanceof ValueModification) {
            ValueModification vMod = (ValueModification)mod;
            vMod.setValue(value.intValue());
            this.modView.getItems().remove((Object)mod);
            if (!this.distView.getItems().remove((Object)value)) {
                throw new IllegalStateException("Could not remove " + value + " from list " + String.valueOf(this.distView.getItems()));
            }
            this.resultView.getItems().add((Object)vMod);
            logger.log(System.Logger.Level.DEBUG, " mods = " + String.valueOf(this.modView.getItems()));
            logger.log(System.Logger.Level.DEBUG, " ints = " + String.valueOf(this.distView.getItems()));
            if (!this.distView.getItems().isEmpty()) {
                this.distView.getSelectionModel().select(0);
            }
            if (!this.modView.getItems().isEmpty()) {
                this.modView.getSelectionModel().select(0);
            }
            this.buttonControl.setDisabled(CloseType.OK, !this.distView.getItems().isEmpty());
        } else {
            logger.log(System.Logger.Level.ERROR, "Unsupported modification type " + String.valueOf(mod));
        }
    }
}

