/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ConfigOption;
import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.export.CharacterExportPlugin;
import de.rpgframework.jfx.pages.CharacterExportPluginSelectorPane;
import de.rpgframework.jfx.pages.CharacterViewLayout;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.util.StringConverter;
import org.prelle.javafx.FlexibleApplication;

public class CharacterExportPluginConfigPane
extends VBox {
    private static final System.Logger logger = System.getLogger(CharacterExportPluginSelectorPane.class.getPackageName());
    public static final ResourceBundle RES = ResourceBundle.getBundle(CharacterViewLayout.class.getName());
    private CharacterExportPlugin<?> plugin;

    public CharacterExportPluginConfigPane(CharacterExportPlugin<?> plugin) {
        this.plugin = plugin;
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
    }

    private void initLayout() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        int i = 0;
        block7: for (final ConfigOption option : this.plugin.getConfiguration()) {
            if (option == null) {
                logger.log(System.Logger.Level.ERROR, "STOP HERE - Option is NullPointer");
                System.exit(1);
            }
            grid.add((Node)new Label(option.getName(Locale.getDefault())), 0, ++i);
            switch (option.getType()) {
                case TEXT: {
                    TextField text = new TextField(String.valueOf(option.getValue()));
                    text.setId(option.getId());
                    text.setUserData((Object)option);
                    text.textProperty().addListener((ov, o, n) -> option.set(n));
                    grid.add((Node)text, 1, i);
                    continue block7;
                }
                case PASSWORD: {
                    PasswordField pass = new PasswordField();
                    pass.setText(String.valueOf(option.getValue()));
                    pass.setId(option.getId());
                    pass.setUserData((Object)option);
                    pass.textProperty().addListener((ov, o, n) -> option.set(n));
                    grid.add((Node)pass, 1, i);
                    continue block7;
                }
                case CHOICE: {
                    ChoiceBox choice = new ChoiceBox();
                    choice.setConverter((StringConverter)new StringConverter<Object>(this){
                        final /* synthetic */ CharacterExportPluginConfigPane this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public String toString(Object object) {
                            return option.getOptionName(object, Locale.getDefault());
                        }

                        public Object fromString(String string) {
                            return null;
                        }
                    });
                    choice.getItems().addAll(option.getChoiceOptions());
                    choice.setValue(option.getValue());
                    choice.setId(option.getId());
                    choice.setUserData((Object)option);
                    choice.valueProperty().addListener((ov, o, n) -> option.set(n));
                    grid.add((Node)choice, 1, i);
                    continue block7;
                }
                case DIRECTORY: {
                    Path oldPath = Paths.get(String.valueOf(option.getValue()), new String[0]);
                    if (!Files.exists(oldPath, new LinkOption[0])) {
                        String newVal = System.getProperties().getProperty("user.home");
                        logger.log(System.Logger.Level.WARNING, "Correct invalid path " + String.valueOf(oldPath) + " to " + newVal);
                        option.set((Object)newVal);
                    }
                    TextField dir = new TextField(String.valueOf(option.getValue()));
                    Button dirSelect = new Button(ResourceI18N.get((ResourceBundle)RES, (String)"button.select"));
                    HBox dirLine = new HBox(5.0);
                    dirLine.getChildren().addAll((Object[])new Node[]{dir, dirSelect});
                    dir.setId(option.getId());
                    dir.setUserData((Object)option);
                    grid.add((Node)dirLine, 1, i);
                    dirSelect.setOnAction(event -> {
                        DirectoryChooser chooser = new DirectoryChooser();
                        File oldValue = null;
                        try {
                            oldValue = new File((String)option.getValue());
                        }
                        catch (NullPointerException e) {
                            logger.log(System.Logger.Level.WARNING, "Error opening " + String.valueOf(option.getValue()) + ": " + String.valueOf(e));
                        }
                        if (oldValue == null || !oldValue.exists()) {
                            oldValue = new File(System.getProperties().getProperty("user.home"));
                        }
                        chooser.setInitialDirectory(oldValue);
                        File selected = chooser.showDialog(FlexibleApplication.getInstance().getAppLayout().getScene().getWindow());
                        if (selected != null) {
                            dir.setText(selected.getAbsolutePath());
                            option.set((Object)selected.getAbsolutePath());
                        }
                    });
                    continue block7;
                }
                case BOOLEAN: {
                    CheckBox box = new CheckBox();
                    box.setId(option.getId());
                    box.setUserData((Object)option);
                    box.setSelected(((Boolean)option.getValue()).booleanValue());
                    box.selectedProperty().addListener((ov, o, n) -> option.set(n));
                    grid.add((Node)box, 1, i);
                    continue block7;
                }
            }
            logger.log(System.Logger.Level.ERROR, "TODO: implement " + String.valueOf(option.getType()) + " config option");
        }
        this.getChildren().add((Object)grid);
    }
}

