/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.rules;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.NumericalValueWith1PoolController;
import de.rpgframework.genericrpg.NumericalValueWith2PoolsController;
import de.rpgframework.genericrpg.NumericalValueWith3PoolsController;
import de.rpgframework.genericrpg.Pool;
import de.rpgframework.genericrpg.PoolCalculation;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.data.ASkillValue;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.ISkill;
import de.rpgframework.genericrpg.data.OneAttributeSkill;
import de.rpgframework.genericrpg.data.TwoAttributeSkill;
import de.rpgframework.jfx.NumericalValueTableCell;
import de.rpgframework.jfx.PoolCell;
import de.rpgframework.jfx.cells.RecommendingDataItemValueTableCell;
import de.rpgframework.jfx.rules.SkillNameTableCell;
import de.rpgframework.jfx.rules.skin.Properties;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.util.Callback;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;
import org.prelle.javafx.public_skins.GridPaneTableViewSkin;

public class SkillTable<A extends IAttribute, S extends ISkill, V extends ASkillValue<S>>
extends TableView<V>
implements ResponsiveControl {
    private static PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle(SkillTable.class.getName());
    private static final System.Logger logger = System.getLogger(SkillTable.class.getPackageName() + ".skill");
    private ObjectProperty<RuleSpecificCharacterObject<A, S, V, ?>> model = new SimpleObjectProperty();
    private ObjectProperty<NumericalValueController<S, V>> controller = new SimpleObjectProperty();
    private BooleanProperty useExpertMode = new SimpleBooleanProperty(false);
    protected BooleanProperty expertModeAvailable = new SimpleBooleanProperty(false);
    protected BooleanProperty hideValueColumns = new SimpleBooleanProperty(false);
    protected BooleanProperty hidePoolColumn = new SimpleBooleanProperty(false);
    private ObjectProperty<Callback<V, CloseType>> actionCallback = new SimpleObjectProperty();
    private TableColumn<V, RecommendationState> colRec;
    private TableColumn<V, String> colName;
    private TableColumn<V, A> colAttrib1;
    private TableColumn<V, A> colAttrib2;
    protected TableColumn<V, Boolean> colDec;
    protected TableColumn<V, Boolean> colInc;
    protected TableColumn<V, Number> colPoints1;
    protected TableColumn<V, Number> colPoints2;
    protected TableColumn<V, Number> colPoints1Only;
    protected TableColumn<V, Number> colPoints2Only;
    private TableColumn<V, Number> colValue;
    private TableColumn<V, Pool<Integer>> colFinal;
    private TableColumn<V, Object> colExtra;
    private ToggleButton headBtnPoints;
    private ToggleButton headBtnPoints2;
    private ToggleGroup toggles = new ToggleGroup();
    private Mode attribMode = Mode.NO_ATTRIB;
    private BooleanProperty showAttributes = new SimpleBooleanProperty(true);
    private Function<V, Boolean> cellVisibilityFactory;
    private boolean isUpdating;

    public SkillTable() {
        this.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.initColumns();
        this.getStyleClass().add((Object)"skill-table");
        this.initInteractivity();
    }

    public SkillTable(List<V> skillse) {
        this();
        this.setData(skillse);
        this.refresh();
    }

    public SkillTable<A, S, V> setAttributeMode(Mode value) {
        this.attribMode = value;
        this.updateLayout();
        return this;
    }

    public SkillTable<A, S, V> setData(List<V> data) {
        logger.log(System.Logger.Level.DEBUG, "setData() with {0} items", data.size());
        this.getItems().setAll(data);
        if (data.isEmpty()) {
            logger.log(System.Logger.Level.WARNING, "Empty skill list");
            return this;
        }
        ISkill cls = (ISkill)((ASkillValue)data.get(0)).getModifyable();
        this.attribMode = Mode.NO_ATTRIB;
        if (cls instanceof OneAttributeSkill) {
            this.attribMode = Mode.ONE_ATTRIB;
            this.colAttrib1.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<V, A>, ObservableValue<A>>(){

                public ObservableValue<A> call(TableColumn.CellDataFeatures<V, A> param) {
                    return new SimpleObjectProperty((Object)((OneAttributeSkill)((ASkillValue)param.getValue()).getModifyable()).getAttribute());
                }
            });
        }
        if (cls instanceof TwoAttributeSkill) {
            this.attribMode = Mode.TWO_ATTRIB;
            this.colAttrib2.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<V, A>, ObservableValue<A>>(){

                public ObservableValue<A> call(TableColumn.CellDataFeatures<V, A> param) {
                    return new SimpleObjectProperty((Object)((TwoAttributeSkill)((ASkillValue)param.getValue()).getModifyable()).getAttribute2());
                }
            });
        }
        this.refresh();
        return this;
    }

    public BooleanProperty useExpertModeProperty() {
        return this.useExpertMode;
    }

    public boolean isUseExpertMode() {
        return this.useExpertMode.get();
    }

    public SkillTable<A, S, V> setUseExpertMode(boolean value) {
        this.useExpertMode.set(value);
        return this;
    }

    public ReadOnlyBooleanProperty expertModeAvailableProperty() {
        return this.expertModeAvailable;
    }

    public boolean isExpertModeAvailable() {
        return this.expertModeAvailable.get();
    }

    public ObjectProperty<Callback<V, CloseType>> actionCallbackProperty() {
        return this.actionCallback;
    }

    public Callback<V, CloseType> getActionCallback() {
        return (Callback)this.actionCallback.get();
    }

    public SkillTable<A, S, V> setActionCallback(Callback<V, CloseType> value) {
        this.actionCallback.set(value);
        return this;
    }

    public ReadOnlyObjectProperty<V> selectedItemProperty() {
        return this.getSelectionModel().selectedItemProperty();
    }

    public V getSelectedItem() {
        return (V)((ASkillValue)this.getSelectionModel().getSelectedItem());
    }

    public BooleanProperty hideValueColumnsProperty() {
        return this.hideValueColumns;
    }

    public boolean isHideValueColumns() {
        return this.hideValueColumns.get();
    }

    public SkillTable<A, S, V> setHideValueColumns(boolean value) {
        this.hideValueColumns.set(value);
        return this;
    }

    public BooleanProperty hidePoolColumnProperty() {
        return this.hidePoolColumn;
    }

    public boolean isHidePoolColumn() {
        return this.hidePoolColumn.get();
    }

    public SkillTable<A, S, V> setHidePoolColumn(boolean value) {
        this.hidePoolColumn.set(value);
        return this;
    }

    private void initColumns() {
        this.colRec = new TableColumn("Rec");
        this.colRec.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<V, RecommendationState>, ObservableValue<RecommendationState>>(){

            public ObservableValue<RecommendationState> call(TableColumn.CellDataFeatures<V, RecommendationState> param) {
                if (param.getValue() == null) {
                    logger.log(System.Logger.Level.ERROR, "No SkillValue for cell " + String.valueOf(param));
                    return new SimpleObjectProperty((Object)RecommendationState.NEUTRAL);
                }
                if (SkillTable.this.controller.get() == null) {
                    return new SimpleObjectProperty((Object)RecommendationState.NEUTRAL);
                }
                return new SimpleObjectProperty((Object)((NumericalValueController)SkillTable.this.controller.get()).getRecommendationState((Object)((ISkill)((ASkillValue)param.getValue()).getModifyable())));
            }
        });
        this.colRec.setCellFactory(lv -> new RecommendingDataItemValueTableCell());
        this.colRec.setPrefWidth(30.0);
        this.colRec.setMaxWidth(30.0);
        this.colName = new TableColumn("Name");
        this.colName.setCellValueFactory(cdv -> new SimpleStringProperty(((ISkill)((ASkillValue)cdv.getValue()).getModifyable()).getChoices().isEmpty() ? ((ISkill)((ASkillValue)cdv.getValue()).getModifyable()).getName(Locale.getDefault()) : (((ASkillValue)cdv.getValue()).getDecision(((Choice)((ISkill)((ASkillValue)cdv.getValue()).getModifyable()).getChoices().get(0)).getUUID()) != null ? ((ASkillValue)cdv.getValue()).getDecision(((Choice)((ISkill)((ASkillValue)cdv.getValue()).getModifyable()).getChoices().get(0)).getUUID()).getValue() : "?")));
        this.colName.setCellFactory(lv -> new SkillNameTableCell(this));
        this.colName.setPrefWidth(160.0);
        this.colName.setMaxWidth(180.0);
        this.colValue = new TableColumn("Value");
        this.colValue.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<V, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<V, Number> param) {
                return new SimpleIntegerProperty(((ASkillValue)param.getValue()).getDistributed());
            }
        });
        this.colValue.setCellFactory(tc -> new NumericalValueTableCell<S, ASkillValue>(this.controller, v -> this.isFinalCellVisible(v)));
        this.colValue.setPrefWidth(80.0);
        this.colValue.setMaxWidth(80.0);
        this.colAttrib1 = new TableColumn();
        this.colAttrib2 = new TableColumn();
        this.colAttrib1.setPrefWidth(45.0);
        this.colAttrib1.setMaxWidth(50.0);
        this.colAttrib2.setPrefWidth(45.0);
        this.colAttrib2.setMaxWidth(50.0);
        this.colAttrib1.setCellFactory(tc -> new TableCell<V, A>(){

            public void updateItem(A item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    this.setText(item.getShortName(Locale.getDefault()));
                }
            }
        });
        this.colAttrib2.setCellFactory(tc -> new TableCell<V, A>(){

            public void updateItem(A item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    this.setText(item.getShortName(Locale.getDefault()));
                }
            }
        });
        this.headBtnPoints = this.createToggle(null);
        this.headBtnPoints2 = this.createToggle(null);
        this.colPoints1 = new TableColumn("?");
        this.colPoints1Only = new TableColumn();
        this.colPoints1Only.setGraphic((Node)this.headBtnPoints);
        this.colPoints1Only.setPrefWidth(50.0);
        this.colPoints2 = new TableColumn("?");
        this.colPoints2Only = new TableColumn();
        this.colPoints2Only.setGraphic((Node)this.headBtnPoints2);
        this.colPoints2Only.setPrefWidth(46.0);
        this.colDec = new TableColumn();
        this.colDec.setPrefWidth(36.0);
        this.colDec.setCellValueFactory(cdv -> new SimpleBooleanProperty(this.toggles.getSelectedToggle() == this.headBtnPoints ? ((NumericalValueWith1PoolController)this.controller.get()).canBeDecreasedPoints((NumericalValue)((ASkillValue)cdv.getValue())).get() || ((NumericalValueWith2PoolsController)this.controller.get()).canBeDecreasedPoints2((NumericalValue)((ASkillValue)cdv.getValue())).get() : ((NumericalValueController)this.controller.get()).canBeDecreased((NumericalValue)((ASkillValue)cdv.getValue())).get()));
        this.colDec.setCellFactory(cdv -> new TableCell<V, Boolean>(){

            public void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                } else {
                    Button btn = new Button(null, (Node)new SymbolIcon("remove"));
                    btn.setDisable(item == false);
                    btn.getStyleClass().add((Object)"mini-button");
                    btn.setOnAction(ev -> {
                        if (SkillTable.this.toggles.getSelectedToggle() == SkillTable.this.headBtnPoints) {
                            logger.log(System.Logger.Level.DEBUG, "DEC");
                            ASkillValue val = (ASkillValue)this.getTableRow().getItem();
                            this.setVisible(SkillTable.this.isFinalCellVisible(val));
                            if (SkillTable.this.toggles.getSelectedToggle() == SkillTable.this.headBtnPoints) {
                                logger.log(System.Logger.Level.DEBUG, "INC Points 1");
                                ((NumericalValueWith1PoolController)SkillTable.this.controller.get()).decreasePoints((NumericalValue)val);
                            } else {
                                logger.log(System.Logger.Level.DEBUG, "INC Points 2");
                                ((NumericalValueWith2PoolsController)SkillTable.this.controller.get()).decreasePoints2((NumericalValue)val);
                            }
                            SkillTable.this.refresh();
                        }
                    });
                    this.setGraphic((Node)btn);
                }
            }
        });
        this.colInc = new TableColumn();
        this.colInc.setPrefWidth(40.0);
        this.colInc.setCellValueFactory(cdv -> new SimpleBooleanProperty(this.toggles.getSelectedToggle() == this.headBtnPoints ? ((NumericalValueWith1PoolController)this.controller.get()).canBeIncreasedPoints((NumericalValue)((ASkillValue)cdv.getValue())).get() || ((NumericalValueWith3PoolsController)this.controller.get()).canBeIncreasedPoints3((NumericalValue)((ASkillValue)cdv.getValue())).get() : ((NumericalValueController)this.controller.get()).canBeIncreased((NumericalValue)((ASkillValue)cdv.getValue())).get()));
        this.colInc.setCellFactory(cdv -> new TableCell<V, Boolean>(){

            public void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                } else {
                    Button btn = new Button(null, (Node)new SymbolIcon("add"));
                    btn.setDisable(item == false);
                    btn.getStyleClass().add((Object)"mini-button");
                    ASkillValue val = (ASkillValue)this.getTableRow().getItem();
                    this.setVisible(SkillTable.this.isFinalCellVisible(val));
                    btn.setOnAction(ev -> {
                        if (SkillTable.this.toggles.getSelectedToggle() == SkillTable.this.headBtnPoints) {
                            logger.log(System.Logger.Level.DEBUG, "INC Points 1");
                            ((NumericalValueWith1PoolController)SkillTable.this.controller.get()).increasePoints((NumericalValue)val);
                        } else {
                            logger.log(System.Logger.Level.DEBUG, "INC Points 2");
                            ((NumericalValueWith2PoolsController)SkillTable.this.controller.get()).increasePoints2((NumericalValue)val);
                        }
                        SkillTable.this.refresh();
                    });
                    this.setGraphic((Node)btn);
                }
            }
        });
        this.colFinal = new TableColumn(ResourceI18N.get((ResourceBundle)RES, (String)"column.pool"));
        this.colFinal.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<V, Pool<Integer>>, ObservableValue<Pool<Integer>>>(){

            public ObservableValue<Pool<Integer>> call(TableColumn.CellDataFeatures<V, Pool<Integer>> param) {
                Pool pool = ((ASkillValue)param.getValue()).getPool();
                if (pool == null) {
                    pool = new Pool();
                    ISkill skill = (ISkill)((ASkillValue)param.getValue()).getModifyable();
                    if (SkillTable.this.model.get() != null) {
                        IAttribute a1;
                        if (skill instanceof TwoAttributeSkill) {
                            IAttribute a12 = ((TwoAttributeSkill)skill).getAttribute();
                            IAttribute a2 = ((TwoAttributeSkill)skill).getAttribute2();
                            if (a12 != null) {
                                pool.addStep(ValueType.NATURAL, new PoolCalculation((Object)((RuleSpecificCharacterObject)SkillTable.this.model.get()).getAttribute(a12).getModifiedValue(), a12.getName()));
                            }
                            if (a2 != null) {
                                pool.addStep(ValueType.NATURAL, new PoolCalculation((Object)((RuleSpecificCharacterObject)SkillTable.this.model.get()).getAttribute(a2).getModifiedValue(), a2.getName()));
                            }
                        } else if (skill instanceof OneAttributeSkill && (a1 = ((OneAttributeSkill)skill).getAttribute()) != null) {
                            pool.addStep(ValueType.NATURAL, new PoolCalculation((Object)((RuleSpecificCharacterObject)SkillTable.this.model.get()).getAttribute(a1).getModifiedValue(), a1.getName()));
                        }
                    }
                }
                return new SimpleObjectProperty((Object)pool);
            }
        });
        this.colFinal.setCellFactory(tc -> new PoolCell());
        this.colFinal.setPrefWidth(30.0);
        this.colFinal.setMaxWidth(50.0);
        this.colExtra = new TableColumn();
        this.updateLayout();
    }

    private boolean isFinalCellVisible(V sVal) {
        if (this.cellVisibilityFactory != null) {
            return this.cellVisibilityFactory.apply(sVal);
        }
        return true;
    }

    private ToggleButton createToggle(String key) {
        ToggleButton lab = new ToggleButton(key != null ? ResourceI18N.get((ResourceBundle)RES, (String)key) : "");
        lab.getStyleClass().add((Object)"table-head-toggle");
        lab.setMaxWidth(Double.MAX_VALUE);
        lab.setToggleGroup(this.toggles);
        return lab;
    }

    private void initInteractivity() {
        this.useExpertModeProperty().addListener(ev -> this.updateLayout());
        this.hideValueColumnsProperty().addListener(ev -> this.updateLayout());
        this.controller.addListener((ov, o, n) -> {
            if (n instanceof NumericalValueWith1PoolController) {
                this.headBtnPoints.setText(((NumericalValueWith1PoolController)n).getColumn1());
            }
            if (n instanceof NumericalValueWith2PoolsController) {
                this.headBtnPoints2.setText(((NumericalValueWith2PoolsController)n).getColumn2());
            }
        });
        this.toggles.selectedToggleProperty().addListener((ov, o, n) -> this.refresh());
    }

    public Skin<?> createDefaultSkin() {
        return new GridPaneTableViewSkin((TableView)this, true).setCenterAfter(1);
    }

    public ObjectProperty<RuleSpecificCharacterObject<A, S, V, ?>> modelProperty() {
        return this.model;
    }

    public RuleSpecificCharacterObject<A, S, V, ?> getModel() {
        return (RuleSpecificCharacterObject)this.model.get();
    }

    public SkillTable<A, S, V> setModel(RuleSpecificCharacterObject<A, S, V, ?> value) {
        this.model.set(value);
        this.refresh();
        return this;
    }

    public ObjectProperty<NumericalValueController<S, V>> controllerProperty() {
        return this.controller;
    }

    public NumericalValueController<S, V> getController() {
        return (NumericalValueController)this.controller.get();
    }

    public SkillTable<A, S, V> setController(NumericalValueController<S, V> value) {
        this.controller.set(value);
        this.refresh();
        return this;
    }

    public boolean is2PointsController() {
        return this.controller.get() != null && this.controller.get() instanceof NumericalValueWith2PoolsController;
    }

    public int getPoints1(V sVal) {
        return this.controller.get() == null ? -1 : ((NumericalValueWith1PoolController)this.controller.get()).getPoints(sVal);
    }

    public int getPoints2(V sVal) {
        return this.controller.get() == null ? -1 : ((NumericalValueWith2PoolsController)this.controller.get()).getPoints2(sVal);
    }

    public int getPoints3(V sVal) {
        return this.controller.get() == null ? -1 : ((NumericalValueWith3PoolsController)this.controller.get()).getPoints3(sVal);
    }

    private void updateColumns() {
        NumericalValueWith1PoolController c1;
        this.colPoints1.setText("?");
        this.colPoints2.setText("?");
        this.colPoints1.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints1((ASkillValue)cdv.getValue())));
        if (this.controller.get() instanceof NumericalValueWith1PoolController) {
            c1 = (NumericalValueWith1PoolController)this.controller.get();
            this.colPoints1.setText(c1.getColumn1());
            this.colPoints1.setCellFactory(col -> {
                NumericalValueController c = new NumericalValueController<S, V>(){
                    final /* synthetic */ SkillTable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public RecommendationState getRecommendationState(S item) {
                        return RecommendationState.NEUTRAL;
                    }

                    public int getValue(V value) {
                        return c1.getPoints(value);
                    }

                    public Possible canBeIncreased(V value) {
                        return c1.canBeIncreasedPoints(value);
                    }

                    public Possible canBeDecreased(V value) {
                        return c1.canBeDecreasedPoints(value);
                    }

                    public OperationResult<V> increase(V value) {
                        return c1.increasePoints(value);
                    }

                    public OperationResult<V> decrease(V value) {
                        return c1.decreasePoints(value);
                    }
                };
                return new NumericalValueTableCell(c, true);
            });
            this.colPoints1Only = new TableColumn();
            this.colPoints1Only.setGraphic((Node)this.headBtnPoints);
            this.colPoints1Only.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints1((ASkillValue)cdv.getValue())));
            this.colPoints1Only.setPrefWidth(50.0);
        }
        if (this.controller.get() instanceof NumericalValueWith3PoolsController) {
            c1 = (NumericalValueWith3PoolsController)this.controller.get();
            this.colPoints2.setText(c1.getColumn3());
            this.colPoints2.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints3((ASkillValue)cdv.getValue())));
            this.colPoints2.setCellFactory(arg_0 -> this.lambda$updateColumns$4((NumericalValueWith3PoolsController)c1, arg_0));
            this.colPoints2Only = new TableColumn();
            this.colPoints2Only.setGraphic((Node)this.headBtnPoints2);
            this.colPoints2Only.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints3((ASkillValue)cdv.getValue())));
            this.colPoints2Only.setPrefWidth(50.0);
        } else if (this.controller.get() instanceof NumericalValueWith2PoolsController) {
            c1 = (NumericalValueWith2PoolsController)this.controller.get();
            this.colPoints2.setText(c1.getColumn2());
            this.colPoints2.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints2((ASkillValue)cdv.getValue())));
            this.colPoints2.setCellFactory(arg_0 -> this.lambda$updateColumns$7((NumericalValueWith2PoolsController)c1, arg_0));
            this.colPoints2Only = new TableColumn();
            this.colPoints2Only.setGraphic((Node)this.headBtnPoints2);
            this.colPoints2Only.setCellValueFactory(cdv -> new SimpleIntegerProperty(this.getPoints2((ASkillValue)cdv.getValue())));
            this.colPoints2Only.setPrefWidth(50.0);
        }
    }

    public void refresh() {
        this.expertModeAvailable.set(this.is2PointsController());
        final Collator collator = Collator.getInstance();
        Collections.sort(this.getItems(), new Comparator<V>(){
            final /* synthetic */ SkillTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(V v1, V v2) {
                if (v1.getModifyable() == null) {
                    return 0;
                }
                if (v2.getModifyable() == null) {
                    return 0;
                }
                return collator.compare(((ISkill)v1.getModifyable()).getName(), ((ISkill)v2.getModifyable()).getName());
            }
        });
        this.getProperties().put((Object)Properties.RECREATE, (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayout() {
        logger.log(System.Logger.Level.DEBUG, "updateLayout");
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        ObservableList observableList = this.getColumns();
        synchronized (observableList) {
            this.updateColumns();
            try {
                boolean expertMode = this.isUseExpertMode();
                boolean enoughSpace = ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL;
                boolean hideValues = this.isHideValueColumns();
                if (!expertMode) {
                    this.toggles.selectToggle(null);
                    if (enoughSpace) {
                        this.getColumns().setAll((Object[])new TableColumn[]{this.colRec, this.colName, this.colValue, this.colFinal});
                    } else {
                        this.getColumns().setAll((Object[])new TableColumn[]{this.colRec, this.colName, this.colValue});
                    }
                    if (hideValues) {
                        this.getColumns().removeAll((Object[])new TableColumn[]{this.colValue, this.colFinal});
                    }
                } else {
                    if (enoughSpace) {
                        this.toggles.selectToggle(null);
                        this.getColumns().setAll((Object[])new TableColumn[]{this.colRec, this.colName, this.colPoints1, this.colPoints2, this.colFinal});
                    } else {
                        this.toggles.selectToggle((Toggle)this.headBtnPoints);
                        this.getColumns().setAll((Object[])new TableColumn[]{this.colRec, this.colName, this.colDec, this.colPoints1Only, this.colPoints2Only, this.colInc});
                    }
                    if (hideValues) {
                        this.getColumns().removeAll((Object[])new TableColumn[]{this.colDec, this.colPoints1Only, this.colPoints2Only, this.colInc});
                    }
                }
                if (enoughSpace) {
                    switch (this.attribMode.ordinal()) {
                        case 2: {
                            this.getColumns().add(this.getColumns().indexOf(this.colName) + 1, this.colAttrib2);
                        }
                        case 1: {
                            this.getColumns().add(this.getColumns().indexOf(this.colName) + 1, this.colAttrib1);
                        }
                    }
                    this.getColumns().add(this.colExtra);
                }
                if (this.hideValueColumns.get()) {
                    this.getColumns().removeAll((Object[])new TableColumn[]{this.colPoints1, this.colPoints2, this.colFinal, this.colDec, this.colPoints1Only, this.colPoints2Only, this.colInc});
                }
                if (this.hidePoolColumn.get()) {
                    this.getColumns().removeAll((Object[])new TableColumn[]{this.colFinal});
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    public void setResponsiveMode(WindowMode value) {
        this.getProperties().put((Object)Properties.WINDOW_MODE, (Object)value);
        this.updateLayout();
        this.requestLayout();
    }

    public void setExtraCellValueFactory(Callback<TableColumn.CellDataFeatures<V, Object>, ObservableValue<Object>> factory) {
        this.colExtra.setCellValueFactory(factory);
        this.refresh();
    }

    public void setExtraCellFactory(Callback<TableColumn<V, Object>, TableCell<V, Object>> factory) {
        this.colExtra.setCellFactory(factory);
        this.refresh();
    }

    public TableColumn<V, RecommendationState> getRecommendationColumn() {
        return this.colRec;
    }

    public TableColumn<V, String> getNameColumn() {
        return this.colName;
    }

    public TableColumn<V, Number> getValueColumn() {
        return this.colValue;
    }

    public TableColumn<V, A> getAttribute1Column() {
        return this.colAttrib1;
    }

    public TableColumn<V, A> getAttribute2Column() {
        return this.colAttrib2;
    }

    public TableColumn<V, Pool<Integer>> getFinalValueColumn() {
        return this.colFinal;
    }

    public TableColumn<V, Object> getExtraColumn() {
        return this.colExtra;
    }

    public BooleanProperty showAttributesProperty() {
        return this.showAttributes;
    }

    public void setCellVisibilityFactory(Function<V, Boolean> factory) {
        this.cellVisibilityFactory = factory;
    }

    private /* synthetic */ TableCell lambda$updateColumns$7(final NumericalValueWith2PoolsController c1, TableColumn col) {
        NumericalValueController c = new NumericalValueController<S, V>(){
            final /* synthetic */ SkillTable this$0;
            {
                this.this$0 = this$0;
            }

            public RecommendationState getRecommendationState(S item) {
                return RecommendationState.NEUTRAL;
            }

            public int getValue(V value) {
                return c1.getPoints2(value);
            }

            public Possible canBeIncreased(V value) {
                return c1.canBeIncreasedPoints2(value);
            }

            public Possible canBeDecreased(V value) {
                return c1.canBeDecreasedPoints2(value);
            }

            public OperationResult<V> increase(V value) {
                return c1.increasePoints2(value);
            }

            public OperationResult<V> decrease(V value) {
                logger.log(System.Logger.Level.WARNING, "decrease2");
                return c1.decreasePoints2(value);
            }
        };
        return new NumericalValueTableCell(c, false);
    }

    private /* synthetic */ TableCell lambda$updateColumns$4(final NumericalValueWith3PoolsController c1, TableColumn col) {
        NumericalValueController c = new NumericalValueController<S, V>(){
            final /* synthetic */ SkillTable this$0;
            {
                this.this$0 = this$0;
            }

            public RecommendationState getRecommendationState(S item) {
                return RecommendationState.NEUTRAL;
            }

            public int getValue(V value) {
                return c1.getPoints3(value);
            }

            public Possible canBeIncreased(V value) {
                return c1.canBeIncreasedPoints3(value);
            }

            public Possible canBeDecreased(V value) {
                return c1.canBeDecreasedPoints3(value);
            }

            public OperationResult<V> increase(V value) {
                logger.log(System.Logger.Level.WARNING, "increase3");
                return c1.increasePoints3(value);
            }

            public OperationResult<V> decrease(V value) {
                logger.log(System.Logger.Level.WARNING, "decrease3");
                return c1.decreasePoints3(value);
            }
        };
        return new NumericalValueTableCell(c, false);
    }

    public static enum Mode {
        NO_ATTRIB,
        ONE_ATTRIB,
        TWO_ATTRIB;

    }
}

