/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.rules.skin;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.data.AttributeValue;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.jfx.rules.AttributeTable;
import de.rpgframework.jfx.rules.skin.Properties;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.prelle.javafx.SymbolIcon;

public class AttributeTableSkin<A extends IAttribute>
extends SkinBase<AttributeTable<A>> {
    private static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private GridPane grid;
    private Map<A, SymbolIcon> recIcon;
    private Map<A, Label> finVal;
    private Map<A, Button> decButton;
    private Map<A, Button> incButton;
    private Map<AttributeTable.AttributeColumn, ColumnData> customColumns;
    private MapChangeListener<Object, Object> propertiesMapListener = c -> {
        if (!c.wasAdded()) {
            return;
        }
        if (Properties.RECREATE.equals(c.getKey())) {
            this.refresh();
            ((AttributeTable)this.getSkinnable()).requestLayout();
            ((AttributeTable)this.getSkinnable()).getProperties().remove((Object)Properties.RECREATE);
        }
    };

    public AttributeTableSkin(AttributeTable control) {
        super((Control)control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.refresh();
        HBox.setHgrow((Node)control, (Priority)Priority.SOMETIMES);
        control.setMaxWidth(Double.MAX_VALUE);
    }

    private void initComponents() {
        this.grid = new GridPane();
        this.grid.setVgap(5.0);
        this.grid.setHgap(10.0);
        this.grid.getStyleClass().add((Object)"attribute-table");
        this.grid.getColumnConstraints().add((Object)new ColumnConstraints());
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setHgrow(Priority.SOMETIMES);
        this.grid.getColumnConstraints().add((Object)col2);
        ColumnConstraints col3 = new ColumnConstraints();
        col3.setHgrow(Priority.SOMETIMES);
        this.grid.getColumnConstraints().add((Object)col3);
        if (((AttributeTable)this.getSkinnable()).getMode() != AttributeTable.Mode.SHOW_ONLY) {
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints());
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints());
        }
        this.customColumns = new HashMap<AttributeTable.AttributeColumn, ColumnData>();
        this.recIcon = new HashMap<A, SymbolIcon>();
        this.finVal = new HashMap<A, Label>();
        this.decButton = new HashMap<A, Button>();
        this.incButton = new HashMap<A, Button>();
        for (IAttribute attr : ((AttributeTable)this.getSkinnable()).getAttributes()) {
            SymbolIcon icon = new SymbolIcon("favorite");
            this.recIcon.put(attr, icon);
            Label fin = new Label("-");
            fin.getStyleClass().add((Object)"base");
            this.finVal.put(attr, fin);
            this.decButton.put(attr, new Button(null, (Node)new SymbolIcon("remove")));
            this.incButton.put(attr, new Button(null, (Node)new SymbolIcon("add")));
        }
        for (AttributeTable.AttributeColumn column : ((AttributeTable)this.getSkinnable()).getColumns()) {
            ColumnData data = new ColumnData();
            data.colDef = column;
            this.customColumns.put(column, data);
            ColumnConstraints colX = new ColumnConstraints();
            colX.setHgrow(Priority.SOMETIMES);
            this.grid.getColumnConstraints().add((Object)colX);
            for (IAttribute attr : ((AttributeTable)this.getSkinnable()).getAttributes()) {
                data.cellData.put(attr, new CellData());
            }
        }
    }

    private void initLayout() {
        int y = 0;
        for (IAttribute attr : ((AttributeTable)this.getSkinnable()).getAttributes()) {
            CellData cell;
            int col = 0;
            SymbolIcon icon = this.recIcon.get(attr);
            icon.setUserData((Object)attr);
            this.grid.add((Node)icon, col++, ++y);
            Label name = new Label(attr.getName());
            name.setMaxWidth(Double.MAX_VALUE);
            name.setOnMouseClicked(ev -> ((AttributeTable)this.getSkinnable()).setSelectedAttribute(attr));
            this.grid.add((Node)name, col, y);
            for (AttributeTable.AttributeColumn column : ((AttributeTable)this.getSkinnable()).getColumns()) {
                if (!column.isShowBeforeValueColumn()) continue;
                cell = this.customColumns.get((Object)column).cellData.get(attr);
                cell.columnNumber = ++col;
                if (attr != ((AttributeTable)this.getSkinnable()).getAttributes()[0]) continue;
                Label header = new Label(column.getTitle());
                this.grid.add((Node)header, col, 0);
            }
            if (((AttributeTable)this.getSkinnable()).getMode() != AttributeTable.Mode.SHOW_ONLY) {
                this.grid.add((Node)this.decButton.get(attr), ++col, y);
            }
            this.grid.add((Node)this.finVal.get(attr), ++col, y);
            if (((AttributeTable)this.getSkinnable()).getMode() != AttributeTable.Mode.SHOW_ONLY) {
                this.grid.add((Node)this.incButton.get(attr), ++col, y);
            }
            for (AttributeTable.AttributeColumn column : ((AttributeTable)this.getSkinnable()).getColumns()) {
                if (column.isShowBeforeValueColumn()) continue;
                cell = this.customColumns.get((Object)column).cellData.get(attr);
                cell.columnNumber = ++col;
            }
        }
        this.getChildren().add((Object)this.grid);
    }

    private void initInteractivity() {
        for (IAttribute key : ((AttributeTable)this.getSkinnable()).getAttributes()) {
            this.decButton.get(key).setOnAction(ev -> this.decrease(key));
            this.incButton.get(key).setOnAction(ev -> this.increase(key));
        }
        ((AttributeTable)this.getSkinnable()).modelProperty().addListener((ov, o, n) -> this.refresh());
        ((AttributeTable)this.getSkinnable()).controllerProperty().addListener((ov, o, n) -> this.refresh());
        ((AttributeTable)this.getSkinnable()).modeProperty().addListener((ov, o, n) -> this.refresh());
        ObservableMap properties = ((AttributeTable)this.getSkinnable()).getProperties();
        properties.remove((Object)Properties.RECREATE);
        properties.addListener(this.propertiesMapListener);
    }

    private void decrease(IAttribute attr) {
        ((AttributeTable)this.getSkinnable()).setSelectedAttribute(attr);
        NumericalValueController controller = ((AttributeTable)this.getSkinnable()).getController();
        RuleSpecificCharacterObject model = ((AttributeTable)this.getSkinnable()).getModel();
        if (controller != null && model != null) {
            controller.decrease((NumericalValue)model.getAttribute(attr));
            this.refresh();
        }
    }

    private void increase(IAttribute attr) {
        ((AttributeTable)this.getSkinnable()).setSelectedAttribute(attr);
        NumericalValueController controller = ((AttributeTable)this.getSkinnable()).getController();
        RuleSpecificCharacterObject model = ((AttributeTable)this.getSkinnable()).getModel();
        if (controller != null && model != null) {
            controller.increase((NumericalValue)model.getAttribute(attr));
            this.refresh();
        }
    }

    private void refresh() {
        NumericalValueController controller = ((AttributeTable)this.getSkinnable()).getController();
        RuleSpecificCharacterObject model = ((AttributeTable)this.getSkinnable()).getModel();
        if (model == null) {
            return;
        }
        int y = 0;
        for (IAttribute attr : ((AttributeTable)this.getSkinnable()).getAttributes()) {
            RecommendationState state;
            ++y;
            AttributeValue val = model.getAttribute(attr);
            Label fin = this.finVal.get(attr);
            if (val != null) {
                fin.setText(String.valueOf(val.getModifiedValue()));
            }
            if (((AttributeTable)this.getSkinnable()).getMode() != AttributeTable.Mode.SHOW_ONLY && controller != null) {
                Button dec = this.decButton.get(attr);
                dec.setDisable(!controller.canBeDecreased((NumericalValue)val).get());
                Button inc = this.incButton.get(attr);
                inc.setDisable(!controller.canBeIncreased((NumericalValue)val).get());
            }
            SymbolIcon icon = this.recIcon.get(attr);
            RecommendationState recommendationState = state = controller != null ? controller.getRecommendationState((Object)attr) : null;
            if (state == null || state == RecommendationState.NEUTRAL) {
                icon.setVisible(false);
            } else {
                icon.setVisible(true);
                icon.setSymbol(state == RecommendationState.STRONGLY_RECOMMENDED ? "favorite" : "outlinestar");
            }
            for (AttributeTable.AttributeColumn column : ((AttributeTable)this.getSkinnable()).getColumns()) {
                ColumnData col = this.customColumns.get(column);
                if (col == null) continue;
                CellData data = col.cellData.get(attr);
                if (data.lastComponent != null) {
                    this.grid.getChildren().remove((Object)data.lastComponent);
                }
                Object cellVal = column.getValueFactory().apply(model, attr);
                data.lastComponent = column.getComponentFactory() != null ? column.getComponentFactory().apply(attr, cellVal) : new Label(String.valueOf(cellVal));
                if (data.lastComponent == null) continue;
                this.grid.add(data.lastComponent, data.columnNumber, y);
            }
        }
        ((AttributeTable)this.getSkinnable()).requestLayout();
    }

    private class ColumnData {
        public AttributeTable.AttributeColumn<A> colDef;
        public Map<A, CellData> cellData = new HashMap();

        private ColumnData() {
        }
    }

    private class CellData {
        public int columnNumber;
        public Node lastComponent;

        private CellData() {
        }
    }
}

