/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.section;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import java.util.function.Function;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.controlsfx.control.GridCell;

public class IconGridCell<T extends DataItem, D extends DataItemValue<T>>
extends GridCell<D> {
    public static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final Image EMPTY = new Image(RPGFrameworkJFXConstants.class.getResourceAsStream("Person.png"));
    private Function<T, Image> imageResolver;
    private SelectionModel<D> selectionModel;
    private ImageView iView;

    public IconGridCell(SelectionModel<D> model, Function<T, Image> resolver) {
        this.imageResolver = resolver;
        this.selectionModel = model;
        this.setContentDisplay(ContentDisplay.TOP);
        this.setGraphicTextGap(0.0);
        this.setStyle("-fx-text-fill: -fx-text-background-color; -fx-padding: 0 2px 0 2px; -fx-font-size:small");
        this.iView = new ImageView();
        this.iView.setFitHeight(64.0);
        this.iView.setFitWidth(64.0);
        this.initInteractivity();
    }

    private void initInteractivity() {
        this.setOnMouseClicked(ev -> {
            if (ev.getClickCount() == 1) {
                this.selectionModel.select((Object)((DataItemValue)this.getItem()));
                this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
            }
        });
    }

    public void updateItem(D item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            if (item != null) {
                Image img;
                if (this.imageResolver != null && (img = this.imageResolver.apply(item.getModifyable())) != null) {
                    this.iView.setImage(img);
                }
                this.setText(item.getNameWithoutRating());
                this.setTooltip(new Tooltip(item.getNameWithoutRating()));
            } else {
                this.iView.setImage(this.EMPTY);
            }
            this.setGraphic((Node)this.iView);
        }
    }
}

