/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.skin;

import de.rpgframework.jfx.FuturisticBorderElement;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public class FuturisticBorderElementSkin
extends SkinBase<FuturisticBorderElement> {
    private static final int SIZE = 100;
    private BorderPane grid;
    private Border border;
    private VBox center;

    public FuturisticBorderElementSkin(FuturisticBorderElement control) {
        super((Control)control);
        this.initComponents();
        this.initInteractivity();
        this.getChildren().add((Object)this.grid);
        this.redraw();
    }

    private void initComponents() {
        this.border = Border.stroke((Paint)((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
        this.center = new VBox();
        this.grid = new BorderPane();
        this.grid.setCenter((Node)this.center);
        this.grid.setMinSize(100.0, 100.0);
        ((FuturisticBorderElement)this.getSkinnable()).setMinSize(100.0, 100.0);
    }

    private void initInteractivity() {
        FuturisticBorderElement skinnable = (FuturisticBorderElement)this.getSkinnable();
        this.grid.centerProperty().addListener((ov, o, n) -> {
            if (n instanceof Region) {
                ((Region)n).setBorder(this.border);
            }
        });
        skinnable.borderWidthProperty().addListener((ov, o, n) -> this.redraw());
        skinnable.borderWidthLeftProperty().addListener((ov, o, n) -> this.redraw());
        skinnable.borderWidthRightProperty().addListener((ov, o, n) -> this.redraw());
        skinnable.borderWidthTopProperty().addListener((ov, o, n) -> this.redraw());
        skinnable.borderWidthBottomProperty().addListener((ov, o, n) -> this.redraw());
    }

    private void redraw() {
        if (((FuturisticBorderElement)this.getSkinnable()).getContent() == null) {
            this.center.getChildren().clear();
        } else {
            this.center.getChildren().setAll((Object[])new Node[]{((FuturisticBorderElement)this.getSkinnable()).getContent()});
        }
        boolean isInner = ((FuturisticBorderElement)this.getSkinnable()).isInnerBorder();
        if (isInner) {
            ((FuturisticBorderElement)this.getSkinnable()).setBorder(this.border);
            this.grid.setBorder(null);
            this.center.setBorder(null);
            this.drawInnerBorder();
        } else {
            ((FuturisticBorderElement)this.getSkinnable()).setBorder(null);
            this.grid.setBorder(null);
            this.center.setBorder(this.border);
            this.drawOuterBorder();
        }
    }

    private void drawOuterBorder() {
        Polygon poly;
        double width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft());
        if (width != 0.0) {
            poly = new Polygon(new double[]{0.0, width, width, 0.0, width, 100.0, 0.0, 100.0 - width, 0.0, width});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setLeft((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft() < 0.0 ? Pos.BOTTOM_LEFT : Pos.TOP_LEFT));
        }
        if ((width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthRight())) != 0.0) {
            poly = new Polygon(new double[]{0.0, 0.0, width, width, width, 100.0 - width, 0.0, 100.0, 0.0, 0.0});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setRight((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthRight() < 0.0 ? Pos.TOP_RIGHT : Pos.BOTTOM_RIGHT));
        } else {
            this.grid.setRight(null);
        }
        width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthTop());
        if (width != 0.0) {
            poly = new Polygon(new double[]{0.0, width, width, 0.0, 100.0 - width, 0.0, 100.0, width, 0.0, width});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setTop((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthTop() < 0.0 ? Pos.BOTTOM_LEFT : Pos.BOTTOM_RIGHT));
            BorderPane.setMargin((Node)poly, (Insets)new Insets(0.0, ((FuturisticBorderElement)this.getSkinnable()).getBorderWidthRight(), 0.0, ((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft()));
        }
        if ((width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthBottom())) != 0.0) {
            poly = new Polygon(new double[]{0.0, 0.0, 100.0, 0.0, 100.0 - width, width, width, width, 0.0, 0.0});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setBottom((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthBottom() < 0.0 ? Pos.TOP_RIGHT : Pos.TOP_LEFT));
            BorderPane.setMargin((Node)poly, (Insets)new Insets(0.0, ((FuturisticBorderElement)this.getSkinnable()).getBorderWidthRight(), 0.0, ((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft()));
        }
    }

    private void drawInnerBorder() {
        Polygon poly;
        double width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft());
        if (width != 0.0) {
            poly = new Polygon(new double[]{0.0, 0.0, width, width, width, 100.0 - width, 0.0, 100.0, 0.0, 0.0});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setLeft((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft() < 0.0 ? Pos.BOTTOM_LEFT : Pos.TOP_LEFT));
        }
        if ((width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthRight())) != 0.0) {
            poly = new Polygon(new double[]{0.0, width, width, 0.0, width, 100.0, 0.0, 100.0 - width, 0.0, width});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setRight((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft() < 0.0 ? Pos.TOP_RIGHT : Pos.BOTTOM_RIGHT));
        }
        if ((width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthTop())) != 0.0) {
            poly = new Polygon(new double[]{0.0, 0.0, 100.0, 0.0, 100.0 - width, width, width, width, 0.0, 0.0});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setTop((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft() < 0.0 ? Pos.BOTTOM_LEFT : Pos.BOTTOM_RIGHT));
        }
        if ((width = Math.abs(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthTop())) != 0.0) {
            poly = new Polygon(new double[]{0.0, width, width, 0.0, 100.0 - width, 0.0, 100.0, width, 0.0, width});
            poly.setFill(((FuturisticBorderElement)this.getSkinnable()).getBorderColor());
            this.grid.setBottom((Node)poly);
            BorderPane.setAlignment((Node)poly, (Pos)(((FuturisticBorderElement)this.getSkinnable()).getBorderWidthLeft() < 0.0 ? Pos.TOP_RIGHT : Pos.TOP_LEFT));
        }
    }
}

