package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class NumericalValueField<T,V extends NumericalValue<T>> extends HBox {

	private V value;
	private NumericalValueController<T,V> control;
	private Button dec;
	private Button inc;
	private TextField tfValue;

	//--------------------------------------------------------------------
	public NumericalValueField(V val, NumericalValueController<T,V> ctrl) {
		this.value = val;
		this.control = ctrl;
		initComponents();
		initLayout();
		initStyle();
		initInteractivity();
		refresh();
	}

	//--------------------------------------------------------------------
	private void initComponents() {
		dec  = new Button("\uE0C6");
		inc  = new Button("\uE0C5");
		tfValue = new TextField();
		tfValue.setPrefColumnCount(2);
		tfValue.setEditable(false);
		tfValue.setFocusTraversable(false);
	}

	//--------------------------------------------------------------------
	private void initLayout() {
		getChildren().addAll(dec, tfValue, inc);
	}

	//--------------------------------------------------------------------
	private void initStyle() {
		inc.getStyleClass().add("mini-button");
		dec.getStyleClass().add("mini-button");
		setStyle("-fx-min-width: 7.5em");
	}

	//--------------------------------------------------------------------
	private void initInteractivity() {
		dec.setOnAction(ev -> control.decrease(value));
		inc.setOnAction(ev -> control.increase(value));
	}

	//--------------------------------------------------------------------
	public void refresh() {
		dec.setDisable(!control.canBeDecreased(value));
		inc.setDisable(!control.canBeIncreased(value));
		tfValue.setText(String.valueOf(value.getPoints()));
	}

	//--------------------------------------------------------------------
	public int getInt() {
		try {
			return Integer.parseInt(tfValue.getText());
		} catch (NumberFormatException e) {
			return 0;
		}
	}

}