/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.gamemaster.jfx.SessionScreenPlugin;
import de.rpgframework.session.SessionScreen;
import de.rpgframework.session.SessionScreenLevel;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;

public class BackgroundImageSessionScreenPlugin
implements SessionScreenPlugin {
    private static final Logger logger = LogManager.getLogger((String)"salomon");
    private static ResourceBundle RES = RPGFrameworkJFXConstants.RES;
    private int width;
    private int height;
    private ImageView iViewGM;
    private ImageView iViewPL;
    private Image shownImage;
    private ChoiceBox<SessionScreen.DisplayHint> cbScaleMode;
    private VBox configPane;
    private VBox contentGM;
    private VBox contentPL;

    public BackgroundImageSessionScreenPlugin() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cbScaleMode = new ChoiceBox(FXCollections.observableArrayList((Object[])SessionScreen.DisplayHint.values()));
        this.cbScaleMode.setValue((Object)SessionScreen.DisplayHint.SCALE);
        this.iViewGM = new ImageView();
        this.iViewPL = new ImageView();
        Image img = new Image(this.getClass().getResourceAsStream("images/splash.png"));
        this.setImage(img);
    }

    private void initLayout() {
        this.configPane = new VBox();
        Label hdScaleMode = new Label(RES.getString("sessscreenplugin.bgimage.scalemode"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdScaleMode, this.cbScaleMode});
        Group grp = new Group(new Node[]{this.iViewGM});
        this.contentGM = new VBox(new Node[]{grp});
        this.contentGM.setStyle("-fx-background-color: black");
        Group grpPL = new Group(new Node[]{this.iViewPL});
        this.contentPL = new VBox(new Node[]{grpPL});
        this.contentPL.setStyle("-fx-background-color: black");
    }

    private void initInteractivity() {
        this.cbScaleMode.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.refreshScale());
    }

    public void setImage(Image img) {
        logger.debug("Set image " + img);
        this.iViewGM.setImage(img);
        this.iViewPL.setImage(img);
        this.shownImage = img;
        this.refreshScale();
    }

    private void refreshScale() {
        double idealScaleX = (double)this.width / this.shownImage.getWidth();
        double idealScaleY = (double)this.height / this.shownImage.getHeight();
        double factor = 0.0;
        switch ((SessionScreen.DisplayHint)this.cbScaleMode.getValue()) {
            case SCALE: {
                factor = Math.min(idealScaleX, idealScaleY);
                logger.info("SCALE: scale " + this.shownImage.getWidth() + "x" + this.shownImage.getHeight() + " with factor " + factor);
                if (factor == idealScaleX) {
                    logger.debug("      Fith Width " + this.width);
                    this.iViewGM.setFitWidth((double)this.width);
                    this.iViewGM.setFitHeight(0.0);
                    this.iViewGM.setPreserveRatio(true);
                    this.iViewPL.setFitWidth((double)this.width);
                    this.iViewPL.setFitHeight(0.0);
                    this.iViewPL.setPreserveRatio(true);
                    break;
                }
                logger.debug("      Fith Height " + this.height);
                this.iViewGM.setFitHeight((double)this.height);
                this.iViewGM.setFitWidth(0.0);
                this.iViewGM.setPreserveRatio(true);
                this.iViewPL.setFitHeight((double)this.height);
                this.iViewPL.setFitWidth(0.0);
                this.iViewPL.setPreserveRatio(true);
                break;
            }
            case FILL: {
                factor = Math.max(idealScaleX, idealScaleY);
                logger.info("FILL: scale " + this.shownImage.getWidth() + "x" + this.shownImage.getHeight() + " with factor " + factor);
                if (factor == idealScaleX) {
                    logger.debug("      Fith Width " + this.width);
                    this.iViewGM.setFitWidth((double)this.width);
                    this.iViewGM.setFitHeight(0.0);
                    this.iViewGM.setPreserveRatio(true);
                    this.iViewPL.setFitWidth((double)this.width);
                    this.iViewPL.setFitHeight(0.0);
                    this.iViewPL.setPreserveRatio(true);
                    break;
                }
                logger.debug("      Fith Height " + this.height);
                this.iViewGM.setFitHeight((double)this.height);
                this.iViewGM.setFitWidth(0.0);
                this.iViewGM.setPreserveRatio(true);
                this.iViewPL.setFitHeight((double)this.height);
                this.iViewPL.setFitWidth(0.0);
                this.iViewPL.setPreserveRatio(true);
            }
        }
        this.iViewGM.setClip((Node)new Rectangle(1920.0, 1080.0));
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]);
    }

    public String getName() {
        return RES.getString("sessscreenplugin.bgimage.name");
    }

    public SessionScreenLevel getLayer() {
        return SessionScreenLevel.BACKGROUND;
    }

    public void setSize(int width, int height) {
        this.height = height;
        this.width = width;
        this.refreshScale();
    }

    public Node getSettingsNode() {
        return this.configPane;
    }

    public Node getContentNode(SessionScreenPlugin.Viewer viewer) {
        if (viewer == SessionScreenPlugin.Viewer.GAMEMASTER) {
            return this.contentGM;
        }
        return this.contentPL;
    }
}

