/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.gamemaster.jfx.SessionScreenPlugin;
import de.rpgframework.session.SessionScreen;
import de.rpgframework.session.SessionScreenLevel;
import java.net.URI;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.shape.Rectangle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;

public class BackgroundMediaPlayerSessionScreenPlugin
implements SessionScreenPlugin {
    private static final Logger logger = LogManager.getLogger((String)"salomon");
    private static ResourceBundle RES = RPGFrameworkJFXConstants.RES;
    private int width;
    private int height;
    private MediaView iViewGM;
    private Media shownImage;
    private ChoiceBox<SessionScreen.DisplayHint> cbScaleMode;
    private VBox configPane;
    private VBox contentGM;

    public BackgroundMediaPlayerSessionScreenPlugin() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cbScaleMode = new ChoiceBox(FXCollections.observableArrayList((Object[])SessionScreen.DisplayHint.values()));
        this.cbScaleMode.setValue((Object)SessionScreen.DisplayHint.SCALE);
        this.iViewGM = new MediaView();
        try {
            URI img = this.getClass().getResource("images/splash.png").toURI();
            this.setMediaURI(img);
        }
        catch (Exception e) {
            logger.error("Failed setting splash screen: " + e);
        }
    }

    private void initLayout() {
        this.configPane = new VBox();
        Label hdScaleMode = new Label(RES.getString("sessscreenplugin.bgimage.scalemode"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdScaleMode, this.cbScaleMode});
        Group grp = new Group(new Node[]{this.iViewGM});
        this.contentGM = new VBox(new Node[]{grp});
        this.contentGM.setStyle("-fx-background-color: black");
    }

    private void initInteractivity() {
        this.cbScaleMode.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.refreshScale());
    }

    public void setMediaURI(URI uri) {
        logger.debug("Set uri " + uri);
        Object uriString = uri.toString();
        if (((String)uriString).startsWith("file:/") && !((String)uriString).startsWith("file:///")) {
            uriString = "file:///" + ((String)uriString).substring(6);
        }
        logger.debug("open " + (String)uriString);
        Media pick = new Media((String)uriString);
        MediaPlayer player = new MediaPlayer(pick);
        player.setOnError(() -> logger.error("media error" + player.getError().toString()));
        player.play();
        this.shownImage = pick;
        this.refreshScale();
    }

    private void refreshScale() {
        if (this.shownImage == null) {
            return;
        }
        double idealScaleX = this.width / this.shownImage.getWidth();
        double idealScaleY = this.height / this.shownImage.getHeight();
        double factor = 0.0;
        switch ((SessionScreen.DisplayHint)this.cbScaleMode.getValue()) {
            case SCALE: {
                factor = Math.min(idealScaleX, idealScaleY);
                logger.info("SCALE: scale " + this.shownImage.getWidth() + "x" + this.shownImage.getHeight() + " with factor " + factor);
                if (factor == idealScaleX) {
                    logger.debug("      Fith Width " + this.width);
                    this.iViewGM.setFitWidth((double)this.width);
                    this.iViewGM.setFitHeight(0.0);
                    this.iViewGM.setPreserveRatio(true);
                    break;
                }
                logger.debug("      Fith Height " + this.height);
                this.iViewGM.setFitHeight((double)this.height);
                this.iViewGM.setFitWidth(0.0);
                this.iViewGM.setPreserveRatio(true);
                break;
            }
            case FILL: {
                factor = Math.max(idealScaleX, idealScaleY);
                logger.info("FILL: scale " + this.shownImage.getWidth() + "x" + this.shownImage.getHeight() + " with factor " + factor);
                if (factor == idealScaleX) {
                    logger.debug("      Fith Width " + this.width);
                    this.iViewGM.setFitWidth((double)this.width);
                    this.iViewGM.setFitHeight(0.0);
                    this.iViewGM.setPreserveRatio(true);
                    break;
                }
                logger.debug("      Fith Height " + this.height);
                this.iViewGM.setFitHeight((double)this.height);
                this.iViewGM.setFitWidth(0.0);
                this.iViewGM.setPreserveRatio(true);
            }
        }
        this.iViewGM.setClip((Node)new Rectangle(1920.0, 1080.0));
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]);
    }

    public String getName() {
        return RES.getString("sessscreenplugin.bgimage.name");
    }

    public SessionScreenLevel getLayer() {
        return SessionScreenLevel.BACKGROUND;
    }

    public void setSize(int width, int height) {
        this.height = height;
        this.width = width;
        this.refreshScale();
    }

    public Node getSettingsNode() {
        return this.configPane;
    }

    public Node getContentNode(SessionScreenPlugin.Viewer viewer) {
        return this.contentGM;
    }
}

