/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.support.combat.Combatant;
import de.rpgframework.support.combat.Party;
import de.rpgframework.support.combat.jfx.BattlefieldView;
import de.rpgframework.support.combat.jfx.TokenFactory;
import de.rpgframework.support.combat.jfx.TokenUpdater;
import de.rpgframework.support.combat.map.BattleMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConstellationBattlefieldView<C extends Combatant, R>
extends StackPane
implements BattlefieldView<C, R> {
    private static final Logger logger = LogManager.getLogger((String)"rpgframework.combat.jfx");
    private static final Color BACKGROUND = Color.WHITE;
    private BattleMap<C, R> battlefield;
    private Canvas canvas;
    private TokenFactory<C> tokenFactory;
    private Map<Combatant, Node> tokens = new HashMap<Combatant, Node>();

    public ConstellationBattlefieldView() {
        this.initComponents();
        this.initInteractivity();
        this.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        this.redraw();
    }

    private void initComponents() {
        this.canvas = new Canvas(500.0, 500.0);
        this.getChildren().add((Object)this.canvas);
    }

    private void initInteractivity() {
        this.widthProperty().addListener((ov, o, n) -> this.sizeChanged());
        this.heightProperty().addListener((ov, o, n) -> this.sizeChanged());
    }

    public void setData(BattleMap<C, R> model) {
        this.battlefield = model;
        if (this.tokenFactory == null) {
            logger.error("Missing CombatantTokenFactory");
            return;
        }
        for (Combatant comb : model.getPositioned()) {
            this.tokens.put(comb, (Node)this.tokenFactory.createToken(comb));
        }
    }

    private void sizeChanged() {
        logger.debug("Size changed to " + this.getWidth() + "x" + this.getHeight());
        this.canvas.setWidth(this.getWidth());
        this.canvas.setHeight(this.getHeight());
        this.redraw();
    }

    public void drawCombatant(GraphicsContext gc, Combatant dc, double x, double y) {
        double w = 40.0;
        double h = 25.0;
        gc.setFill((Paint)Color.RED);
        gc.fillArc(x - w, y - h, w * 2.0, h * 2.0, 0.0, 360.0, ArcType.OPEN);
        gc.setLineWidth(1.0);
        gc.setStroke((Paint)Color.BLACK);
        gc.strokeText(dc.getName(), x - w * 0.8, y, w * 1.7);
        gc.drawImage(new Image((InputStream)new ByteArrayInputStream(dc.getAvatar())), x, y, w, h);
    }

    private void redraw() {
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill((Paint)BACKGROUND);
        gc.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        double centerX = this.canvas.getWidth() / 2.0;
        double centerY = this.canvas.getHeight() / 2.0;
        double radiusX = centerX * 0.8;
        double radiusY = centerY * 0.8;
        double innerRadiusX = centerX * 0.2;
        double innerRadiusY = centerY * 0.2;
        gc.setStroke((Paint)Color.rgb((int)20, (int)20, (int)20));
        gc.setLineWidth(3.0);
        gc.strokeArc(centerX - radiusX, centerY - radiusY, radiusX * 2.0, radiusY * 2.0, 0.0, 360.0, ArcType.OPEN);
        if (this.battlefield == null) {
            return;
        }
        List unpositioned = this.battlefield.getUnpositioned();
        ArrayList<Combatant> posOpponents = new ArrayList<Combatant>();
        ArrayList<Combatant> unposOpponents = new ArrayList<Combatant>();
        for (Combatant comb : (Party)this.battlefield.getCombat().getGroups().get(1)) {
            if (!unpositioned.contains(comb)) {
                posOpponents.add(comb);
                continue;
            }
            unposOpponents.add(comb);
        }
        double anglePerHero = 360.0 / (double)((Party)this.battlefield.getCombat().getGroups().get(0)).size();
        int pos = 0;
        for (Combatant comb : (Party)this.battlefield.getCombat().getGroups().get(0)) {
            double angle = anglePerHero * (double)pos;
            double angle2 = Math.PI * 2 / (360.0 / angle);
            double x = Math.cos(angle2) * radiusX + centerX;
            double y = Math.sin(angle2) * radiusY + centerY;
            logger.debug("Draw " + pos + " at " + x + "x" + y);
            gc.setFill((Paint)Color.BLACK);
            gc.fillOval(x, y, 10.0, 10.0);
            this.drawCombatant(gc, comb, x, y);
            ++pos;
        }
        double anglePerOpp = 360.0 / (double)unposOpponents.size();
        pos = 0;
        for (Combatant comb : unposOpponents) {
            double angle = anglePerOpp * (double)pos;
            double angle2 = Math.PI * 2 / (360.0 / angle);
            double x = Math.cos(angle2) * innerRadiusX + centerX;
            double y = Math.sin(angle2) * innerRadiusY + centerY;
            logger.debug("Draw " + pos + " at " + x + "x" + y);
            gc.setFill((Paint)Color.BLACK);
            gc.fillOval(x, y, 10.0, 10.0);
            this.drawCombatant(gc, comb, x, y);
            ++pos;
        }
    }

    public void setTokenFactory(TokenFactory<C> factory) {
        this.tokenFactory = factory;
    }

    public void setTokenUpdater(TokenUpdater<C> updater) {
    }
}

