/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.gamemaster.jfx.SessionScreenPlugin;
import de.rpgframework.session.SessionScreenLevel;
import java.util.ResourceBundle;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;

public class ExploreScreenPlugin
implements SessionScreenPlugin {
    private static ResourceBundle RES = RPGFrameworkJFXConstants.RES;
    private CheckBox cbVisible;
    private Slider slGridWidth;
    private Button btnReset;
    private VBox configPane;
    private Canvas canvasGM;
    private Canvas canvasPL;
    private Group grpGM;

    public ExploreScreenPlugin() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cbVisible = new CheckBox(RES.getString("sessscreenplugin.explore.visible"));
        this.cbVisible.setWrapText(true);
        this.slGridWidth = new Slider(20.0, 100.0, 40.0);
        this.btnReset = new Button(RES.getString("sessscreenplugin.explore.reset"));
        this.btnReset.getStyleClass().add((Object)"border-all");
        this.canvasGM = new Canvas(1920.0, 1080.0);
        this.canvasGM.getGraphicsContext2D().setFill((Paint)Color.BLACK);
        this.canvasGM.getGraphicsContext2D().fillRect(0.0, 0.0, this.canvasGM.getWidth(), this.canvasGM.getHeight());
        this.canvasPL = new Canvas(1920.0, 1080.0);
        this.canvasPL.getGraphicsContext2D().setFill((Paint)Color.BLACK);
        this.canvasPL.getGraphicsContext2D().fillRect(0.0, 0.0, this.canvasGM.getWidth(), this.canvasGM.getHeight());
        this.grpGM = new Group(new Node[]{this.canvasGM});
        this.grpGM.setStyle("-fx-opacity: 0.5");
        this.grpGM.setOnMousePressed(ev -> this.uncover(ev.getX(), ev.getY()));
        this.grpGM.setOnMouseDragged(ev -> this.uncover(ev.getX(), ev.getY()));
    }

    private void uncover(double x, double y) {
        double offset = this.slGridWidth.getValue() / 2.0;
        this.canvasGM.getGraphicsContext2D().clearRect(x - offset, y - offset, this.slGridWidth.getValue(), this.slGridWidth.getValue());
        this.canvasPL.getGraphicsContext2D().clearRect(x - offset, y - offset, this.slGridWidth.getValue(), this.slGridWidth.getValue());
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_UNCOVERED, (Object[])new Object[0]);
    }

    private void initLayout() {
        this.configPane = new VBox(20.0);
        this.configPane.getChildren().addAll((Object[])new Node[]{this.cbVisible, this.btnReset});
        Label hdGridWidth = new Label(RES.getString("sessscreenplugin.explore.brushwidth"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdGridWidth, this.slGridWidth});
    }

    private void reset() {
        this.canvasGM.getGraphicsContext2D().setFill((Paint)Color.BLACK);
        this.canvasGM.getGraphicsContext2D().fillRect(0.0, 0.0, this.canvasGM.getWidth(), this.canvasGM.getHeight());
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_UNCOVERED, (Object[])new Object[0]);
    }

    private void initInteractivity() {
        this.cbVisible.selectedProperty().addListener((ov, o, n) -> BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]));
        this.btnReset.setOnAction(ev -> this.reset());
    }

    public String getName() {
        return RES.getString("sessscreenplugin.explore.name");
    }

    public SessionScreenLevel getLayer() {
        return SessionScreenLevel.EXPLORED;
    }

    public void setSize(int width, int height) {
    }

    public Node getSettingsNode() {
        return this.configPane;
    }

    public Node getContentNode(SessionScreenPlugin.Viewer viewer) {
        if (!this.cbVisible.isSelected()) {
            return null;
        }
        if (viewer == SessionScreenPlugin.Viewer.PLAYER) {
            return this.canvasPL;
        }
        return this.grpGM;
    }
}

