/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.support.combat.Combatant;
import de.rpgframework.support.combat.jfx.Token;
import de.rpgframework.support.combat.jfx.TokenFactory;
import de.rpgframework.support.combat.jfx.TokenUpdater;
import de.rpgframework.support.combat.map.BattleMapListener;
import de.rpgframework.support.combat.map.MatrixBattleMap;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MatrixBattleMapView<C extends Combatant, R>
extends StackPane
implements BattleMapListener {
    private static final Logger logger = LogManager.getLogger((String)"babylon");
    private static final Paint TRANSPARENT = new Color(1.0, 1.0, 1.0, 0.0);
    private IntegerProperty cellSizeProperty = new SimpleIntegerProperty(80);
    private MatrixBattleMap<C, R> model;
    private TokenFactory<C> tokenFactory;
    private TokenUpdater<C> tokenUpdater;
    private Canvas background;
    private Canvas grid;
    private GridPane tokens;
    private int highX;
    private int highY;
    private Region region;

    public MatrixBattleMapView() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.setStyle("-fx-background-color: rgba(255,255,255,0.8);");
        this.setStyle("-fx-background-image: url(images/battlemap_river.jpg);");
    }

    public MatrixBattleMapView(MatrixBattleMap<C, R> data) {
        this();
        this.setData(data);
    }

    private void initComponents() {
        this.background = new Canvas();
        this.grid = new Canvas();
        this.tokens = new GridPane();
        this.region = new Region();
        this.region.setPrefSize((double)this.cellSizeProperty.get(), (double)this.cellSizeProperty.get());
        this.region.setStyle("-fx-background-color: rgba(0,0,0,0.8);");
    }

    private void initLayout() {
        this.getChildren().addAll((Object[])new Node[]{this.background, this.grid, this.tokens});
    }

    private void initInteractivity() {
        this.grid.widthProperty().bind((ObservableValue)this.widthProperty());
        this.grid.heightProperty().bind((ObservableValue)this.heightProperty());
        this.grid.widthProperty().addListener((ov, o, n) -> this.refresh());
        this.grid.heightProperty().addListener((ov, o, n) -> this.refresh());
        this.setOnDragOver(event -> this.dragOver((DragEvent)event));
        this.setOnDragDropped(event -> this.dragDropped((DragEvent)event));
    }

    public void setTokenFactory(TokenFactory<C> factory) {
        this.tokenFactory = factory;
        this.refresh();
    }

    public void setTokenUpdater(TokenUpdater<C> data) {
        this.tokenUpdater = data;
        this.refresh();
    }

    private void refresh() {
        logger.info("Draw " + this.grid.getWidth() + "x" + this.grid.getHeight());
        GraphicsContext gc = this.grid.getGraphicsContext2D();
        gc.setFill(TRANSPARENT);
        gc.fill();
        int cellSize = this.cellSizeProperty.get();
        gc.setStroke((Paint)Color.BLACK);
        int numX = (int)this.grid.getWidth() / cellSize;
        int numY = (int)this.grid.getHeight() / cellSize;
        logger.debug("Cols/Rows " + numX + "/" + numY);
        for (int x = 0; x <= numX; ++x) {
            gc.strokeLine((double)(x * cellSize), 0.0, (double)(x * cellSize), this.grid.getHeight());
        }
        for (int y = 0; y <= numY; ++y) {
            gc.strokeLine(0.0, (double)(y * cellSize), this.grid.getWidth(), (double)(y * cellSize));
        }
        this.tokens.getChildren().clear();
        if (this.model == null) {
            return;
        }
        for (Combatant comb : this.model.getPositioned()) {
            int[] pos = this.model.getPosition(comb);
            if (pos == null) continue;
            Token token = this.tokenFactory.createToken(comb);
            if (this.tokenUpdater != null) {
                this.tokenUpdater.updateToken(token, comb);
            } else {
                logger.error("Missing token updater");
            }
            this.tokens.add((Node)token, pos[0], pos[1]);
        }
    }

    public void setData(MatrixBattleMap<C, R> data) {
        int i;
        logger.debug("setData " + data);
        if (data == null) {
            throw new NullPointerException("BattleMap is null");
        }
        if (this.model != null) {
            this.model.removeBattleMapListener((BattleMapListener)this);
            this.tokens.getColumnConstraints().clear();
            this.tokens.getRowConstraints().clear();
        }
        this.model = data;
        this.model.addBattleMapListener((BattleMapListener)this);
        ColumnConstraints cols = new ColumnConstraints((double)this.cellSizeProperty.get());
        RowConstraints rows = new RowConstraints((double)this.cellSizeProperty.get());
        for (i = 0; i < this.model.getWidth(); ++i) {
            this.tokens.getColumnConstraints().add((Object)cols);
        }
        for (i = 0; i < this.model.getHeight(); ++i) {
            this.tokens.getRowConstraints().add((Object)rows);
        }
        this.refresh();
    }

    public void battleMapChanged() {
        logger.debug("battleMapChanged");
        this.refresh();
    }

    private void dragOver(DragEvent event) {
        int offX = (int)event.getX() / this.cellSizeProperty.get();
        int offY = (int)event.getY() / this.cellSizeProperty.get();
        if (offX == this.highX && offY == this.highY) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            return;
        }
        this.tokens.getChildren().remove((Object)this.region);
        this.highX = offX;
        this.highY = offY;
        this.tokens.add((Node)this.region, this.highX, this.highY);
        if (event.getGestureSource() != event.getSource()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private C getCombatantById(String combId) {
        for (Combatant tmp : this.model.getPositioned()) {
            if (!tmp.toString().equals(combId)) continue;
            return (C)tmp;
        }
        for (Combatant tmp : this.model.getUnpositioned()) {
            if (!tmp.toString().equals(combId)) continue;
            return (C)tmp;
        }
        return null;
    }

    private void dragDropped(DragEvent event) {
        int offX = (int)event.getX() / this.cellSizeProperty.get();
        int offY = (int)event.getY() / this.cellSizeProperty.get();
        logger.debug("Dropped over " + offX + "," + offY);
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            C comb = this.getCombatantById(db.getString());
            logger.debug("Move '" + comb.getName() + "' to " + offX + "," + offY);
            this.model.setPosition(comb, offX, offY);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
        this.tokens.getChildren().remove((Object)this.region);
    }
}

