/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.gamemaster.jfx;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.gamemaster.jfx.SessionScreenPlugin;
import de.rpgframework.session.SessionScreenLevel;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;

public class RegularGridScreenPlugin
implements SessionScreenPlugin {
    private static ResourceBundle RES = RPGFrameworkJFXConstants.RES;
    private CheckBox cbVisible;
    private Slider slGridWidth;
    private Slider slOffsetX;
    private Slider slOffsetY;
    private ColorPicker cbColor;
    private VBox configPane;
    private Canvas canvasGM;
    private Canvas canvasPL;

    public RegularGridScreenPlugin() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cbVisible = new CheckBox(RES.getString("sessscreenplugin.gridregular.visible"));
        this.slGridWidth = new Slider(20.0, 100.0, 40.0);
        this.slOffsetX = new Slider(0.0, this.slGridWidth.getValue(), 0.0);
        this.slOffsetY = new Slider(0.0, this.slGridWidth.getValue(), 0.0);
        this.cbColor = new ColorPicker();
        this.cbColor.setValue((Object)Color.BLACK);
    }

    private void initLayout() {
        this.configPane = new VBox();
        this.configPane.getChildren().add((Object)this.cbVisible);
        Label hdGridWidth = new Label(RES.getString("sessscreenplugin.gridregular.gridwidth"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdGridWidth, this.slGridWidth});
        Label hdOffsetX = new Label(RES.getString("sessscreenplugin.gridregular.offsetx"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdOffsetX, this.slOffsetX});
        Label hdOffsetY = new Label(RES.getString("sessscreenplugin.gridregular.offsety"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdOffsetY, this.slOffsetY});
        Label hdColor = new Label(RES.getString("sessscreenplugin.gridregular.color"));
        this.configPane.getChildren().addAll((Object[])new Node[]{hdColor, this.cbColor});
        this.canvasGM = new Canvas(1920.0, 1080.0);
        this.canvasPL = new Canvas(1920.0, 1080.0);
        this.canvasGM.setMouseTransparent(true);
    }

    private void initInteractivity() {
        this.cbVisible.selectedProperty().addListener((ov, o, n) -> BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]));
        this.slGridWidth.valueProperty().addListener((ov, o, n) -> {
            this.slOffsetX.setMax(((Double)n).doubleValue());
            this.slOffsetY.setMax(((Double)n).doubleValue());
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_REGULAR_GRID_CHANGED, (Object[])new Object[]{this.slGridWidth.getValue(), this.slOffsetX.getValue(), this.slOffsetY.getValue()});
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]);
        });
        this.slOffsetX.valueProperty().addListener((ov, o, n) -> {
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_REGULAR_GRID_CHANGED, (Object[])new Object[]{this.slGridWidth.getValue(), this.slOffsetX.getValue(), this.slOffsetY.getValue()});
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]);
        });
        this.slOffsetY.valueProperty().addListener((ov, o, n) -> {
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_REGULAR_GRID_CHANGED, (Object[])new Object[]{this.slGridWidth.getValue(), this.slOffsetX.getValue(), this.slOffsetY.getValue()});
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]);
        });
        this.cbColor.valueProperty().addListener((ov, o, n) -> BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.SESSION_SCREEN_CHANGED, (Object[])new Object[0]));
    }

    public String getName() {
        return RES.getString("sessscreenplugin.gridregular.name");
    }

    public SessionScreenLevel getLayer() {
        return SessionScreenLevel.GRID;
    }

    public void setSize(int width, int height) {
    }

    public Node getSettingsNode() {
        return this.configPane;
    }

    public Node getContentNode(SessionScreenPlugin.Viewer viewer) {
        if (!this.cbVisible.isSelected()) {
            return null;
        }
        Canvas canvas = viewer == SessionScreenPlugin.Viewer.GAMEMASTER ? this.canvasGM : this.canvasPL;
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        gc.setStroke((Paint)this.cbColor.getValue());
        int x = (int)this.slOffsetX.getValue();
        while ((double)x < canvas.getWidth()) {
            gc.strokeLine((double)x, 0.0, (double)x, canvas.getHeight());
            x += (int)this.slGridWidth.getValue();
        }
        int y = (int)this.slOffsetY.getValue();
        while ((double)y < canvas.getHeight()) {
            gc.strokeLine(0.0, (double)y, canvas.getWidth(), (double)y);
            y += (int)this.slGridWidth.getValue();
        }
        return canvas;
    }
}

