/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.prelle.rpgframework.jfx.CardTileSkin;

public class CardTile
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "card-tile";
    private StringProperty text;
    private BooleanProperty attentionFlag;
    private ObjectProperty<List<String>> attentionText;
    private ObjectProperty<Parent> backside;
    private ObjectProperty<Side> visibleSide;
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        protected void invalidated() {
            CardTile.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return CardTile.this;
        }

        public String getName() {
            return "onAction";
        }
    };

    public CardTile(String id, String i18nTitle) {
        this.setId(id);
        this.text = new SimpleStringProperty(i18nTitle);
        this.attentionFlag = new SimpleBooleanProperty(false);
        this.attentionText = new SimpleObjectProperty();
        this.backside = new SimpleObjectProperty();
        this.visibleSide = new SimpleObjectProperty((Object)Side.FRONT);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public String getText() {
        return this.text.getValue();
    }

    public void setText(String text) {
        this.text.setValue(text);
    }

    public BooleanProperty attentionFlagProperty() {
        return this.attentionFlag;
    }

    public boolean getAttentionFlag() {
        return this.attentionFlag.getValue();
    }

    public void setAttentionFlag(boolean value) {
        this.attentionFlag.setValue(Boolean.valueOf(value));
    }

    public ObjectProperty<List<String>> attentionTextProperty() {
        return this.attentionText;
    }

    public List<String> getAttentionText() {
        return (List)this.attentionText.getValue();
    }

    public void setAttentionText(List<String> text) {
        this.attentionText.setValue(text);
    }

    public ObjectProperty<Parent> backsideProperty() {
        return this.backside;
    }

    public Parent getBackside() {
        return (Parent)this.backside.getValue();
    }

    public void setBackside(Parent value) {
        this.backside.setValue((Object)value);
    }

    public ObjectProperty<Side> visibleSideProperty() {
        return this.visibleSide;
    }

    public Side getVisibleSide() {
        return (Side)((Object)this.visibleSide.getValue());
    }

    public void setVisibleSide(Side value) {
        this.visibleSide.setValue((Object)value);
    }

    public Skin<CardTile> createDefaultSkin() {
        return new CardTileSkin(this);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public void fire() {
        if (!this.isDisabled()) {
            this.fireEvent((Event)new ActionEvent());
        }
    }

    public static enum Side {
        FRONT,
        BACK;

    }
}

