/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.VBox;
import org.prelle.javafx.AttentionPane;
import org.prelle.javafx.FlipControl;
import org.prelle.rpgframework.jfx.CardTile;

public class CardTileSkin
extends SkinBase<CardTile> {
    private AttentionPane attention;
    private FlipControl flip;
    private Label front;
    private Label backTitle;
    private VBox back;

    public CardTileSkin(CardTile control) {
        super((Control)control);
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.getChildren().add((Object)this.attention);
        this.updateVisible();
    }

    private void initComponents() {
        this.flip = new FlipControl(Orientation.VERTICAL, true);
        this.flip.setId(((CardTile)this.getSkinnable()).getId());
        this.front = new Label(((CardTile)this.getSkinnable()).getText());
        this.front.setWrapText(true);
        this.front.setAlignment(Pos.TOP_LEFT);
        this.backTitle = new Label(((CardTile)this.getSkinnable()).getText());
        this.back = new VBox();
        this.attention = new AttentionPane((Node)this.flip);
    }

    private void initLayout() {
        this.front.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.back.getChildren().add((Object)this.backTitle);
        if (((CardTile)this.getSkinnable()).getBackside() != null) {
            this.back.getChildren().add((Object)((CardTile)this.getSkinnable()).getBackside());
        }
        this.flip.getItems().addAll((Object[])new Node[]{this.front, this.back});
        this.flip.setVisibleIndex(0);
    }

    private void initStyle() {
        this.front.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "front"});
        this.back.getStyleClass().addAll((Object[])new String[]{"back"});
        this.backTitle.getStyleClass().add((Object)"section-head");
    }

    private void initInteractivity() {
        ((CardTile)this.getSkinnable()).textProperty().addListener((ov, o, n) -> this.front.setText(n));
        ((CardTile)this.getSkinnable()).backsideProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.flip.getItems().remove(o);
            }
            this.flip.getItems().add(n);
        });
        ((CardTile)this.getSkinnable()).attentionFlagProperty().addListener((ov, o, n) -> this.attention.setAttentionFlag(n.booleanValue()));
        ((CardTile)this.getSkinnable()).attentionTextProperty().addListener((ov, o, n) -> this.attention.setAttentionToolTip(n));
        ((CardTile)this.getSkinnable()).visibleSideProperty().addListener((ov, o, n) -> this.updateVisible());
        this.flip.visibleIndexProperty().addListener((ov, o, n) -> {
            if ((Integer)n == 0) {
                ((CardTile)this.getSkinnable()).setVisibleSide(CardTile.Side.FRONT);
            }
            if ((Integer)n == 1) {
                ((CardTile)this.getSkinnable()).setVisibleSide(CardTile.Side.BACK);
            }
        });
        this.flip.setOnMouseClicked(event -> ((CardTile)this.getSkinnable()).fire());
        this.flip.onDragDetectedProperty().bind((ObservableValue)((CardTile)this.getSkinnable()).onDragDetectedProperty());
        this.flip.onDragEnteredProperty().bind((ObservableValue)((CardTile)this.getSkinnable()).onDragEnteredProperty());
        this.flip.onDragOverProperty().bind((ObservableValue)((CardTile)this.getSkinnable()).onDragOverProperty());
        this.flip.onDragExitedProperty().bind((ObservableValue)((CardTile)this.getSkinnable()).onDragExitedProperty());
        this.flip.onDragDroppedProperty().bind((ObservableValue)((CardTile)this.getSkinnable()).onDragDroppedProperty());
    }

    private void updateVisible() {
        switch (((CardTile)this.getSkinnable()).getVisibleSide()) {
            case FRONT: {
                if (this.flip.getVisibleIndex() == 0) break;
                this.flip.flip();
                break;
            }
            case BACK: {
                if (this.flip.getVisibleIndex() == 1) break;
                this.flip.flip();
            }
        }
    }
}

