/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import java.util.Collection;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.prelle.javafx.ManagedScreenPage;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.WindowMode;
import org.prelle.rpgframework.jfx.IHasDescriptionPane;
import org.prelle.rpgframework.jfx.OptionalDescriptionPane;
import org.prelle.rpgframework.jfx.Section;
import org.prelle.rpgframework.jfx.skin.CharacterDocumentViewPane;

public class CharacterDocumentView
extends ManagedScreenPage
implements ResponsiveControl,
IHasDescriptionPane {
    public static final String DEFAULT_STYLE_CLASS = "character-document-view";
    @FXML
    private ObservableList<Section> sectionListProperty = FXCollections.observableArrayList();
    @FXML
    private FloatProperty pointsFreeProperty = new SimpleFloatProperty();
    @FXML
    private StringProperty pointsNameProperty = new SimpleStringProperty();
    private transient CharacterDocumentViewPane pane;
    private transient Label descrHead;
    private transient Label descrSubHead;
    private transient Node descrNode;
    private transient VBox descriptionBX;
    private transient ScrollPane scroll;

    public CharacterDocumentView() {
        super("Title not set");
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.pane = new CharacterDocumentViewPane();
        this.descrHead = new Label();
        this.descrHead.getStyleClass().add((Object)"title");
        this.descrSubHead = new Label();
        this.descrSubHead.getStyleClass().add((Object)"subtitle");
        this.descrNode = new Label();
        this.descrHead.setWrapText(true);
        this.descrSubHead.setWrapText(true);
        ((Label)this.descrNode).setWrapText(true);
    }

    private void initLayout() {
        this.descriptionBX = new VBox(new Node[]{this.descrHead, this.descrSubHead, this.descrNode});
        this.descriptionBX.getStyleClass().add((Object)"description-text");
        VBox.setVgrow((Node)this.descrNode, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)this.descrSubHead, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        VBox dummy = new VBox(new Node[]{this.descriptionBX});
        dummy.getStyleClass().add((Object)"character-document-view-description");
        OptionalDescriptionPane paneWithDescr = new OptionalDescriptionPane((Node)this.pane, (Node)dummy);
        this.setContent((Node)paneWithDescr);
    }

    private void initInteractivity() {
        this.sectionListProperty.addListener((ListChangeListener)new ListChangeListener<Section>(){

            public void onChanged(ListChangeListener.Change<? extends Section> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        CharacterDocumentView.this.pane.getSectionList().addAll((Collection)c.getAddedSubList());
                    }
                    if (!c.wasRemoved()) continue;
                    CharacterDocumentView.this.pane.getSectionList().removeAll((Collection)c.getRemoved());
                }
            }
        });
        this.pane.pointsFreeProperty().bind((ObservableValue)this.pointsFreeProperty);
        this.pane.pointsNameProperty().bind((ObservableValue)this.pointsNameProperty);
    }

    public ObservableList<Section> getSectionList() {
        return this.sectionListProperty;
    }

    public FloatProperty pointsFreeProperty() {
        return this.pointsFreeProperty;
    }

    public void setPointsFree(float value) {
        this.pointsFreeProperty.set(value);
    }

    public float getPointsFree() {
        return this.pointsFreeProperty.get();
    }

    public StringProperty pointsNameProperty() {
        return this.pointsNameProperty;
    }

    public void setPointsNameProperty(String value) {
        this.pointsNameProperty.set((Object)value);
    }

    public String getPointsNameProperty() {
        return (String)this.pointsNameProperty.get();
    }

    public void setResponsiveMode(WindowMode value) {
        this.pane.setResponsiveMode(value);
    }

    public void jumpTo(Section section) {
    }

    @Override
    public void setDescriptionHeading(String value) {
        this.descrHead.setText(value);
    }

    @Override
    public void setDescriptionPageRef(String value) {
        this.descrSubHead.setText(value);
    }

    @Override
    public void setDescriptionNode(Node value) {
        this.descriptionBX.getChildren().remove((Object)this.descrNode);
        this.descriptionBX.getChildren().remove((Object)this.scroll);
        this.descrNode = value;
        if (value != null) {
            VBox.setVgrow((Node)this.descrNode, (Priority)Priority.ALWAYS);
            this.scroll = new ScrollPane(this.descrNode);
            this.scroll.setFitToWidth(true);
            this.scroll.setMaxHeight(Double.MAX_VALUE);
            this.scroll.setStyle("-fx-pref-height: 50em");
            VBox.setVgrow((Node)this.scroll, (Priority)Priority.ALWAYS);
            this.descriptionBX.getChildren().add((Object)this.scroll);
        }
    }

    @Override
    public void setDescriptionText(String value) {
        this.descriptionBX.getChildren().remove((Object)this.descrNode);
        this.descriptionBX.getChildren().remove((Object)this.scroll);
        this.descrNode = new Label(value);
        VBox.setVgrow((Node)this.descrNode, (Priority)Priority.ALWAYS);
        ((Label)this.descrNode).setWrapText(true);
        this.scroll = new ScrollPane(this.descrNode);
        this.scroll.setFitToWidth(true);
        this.scroll.setMaxHeight(Double.MAX_VALUE);
        this.scroll.setStyle("-fx-pref-height: 50em");
        VBox.setVgrow((Node)this.scroll, (Priority)Priority.ALWAYS);
        this.descriptionBX.getChildren().add((Object)this.scroll);
    }
}

