/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.HardcopyPluginData;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DescriptionPane
extends VBox {
    private Label descrHead = new Label();
    private Label descrSubHead;
    private Label descrNode;

    public DescriptionPane() {
        this.descrHead.getStyleClass().add((Object)"title");
        this.descrSubHead = new Label();
        this.descrSubHead.getStyleClass().add((Object)"subtitle");
        this.descrNode = new Label();
        this.descrHead.setWrapText(true);
        this.descrSubHead.setWrapText(true);
        this.descrNode.setWrapText(true);
        this.getChildren().addAll((Object[])new Node[]{this.descrHead, this.descrSubHead, this.descrNode});
        this.getStyleClass().add((Object)"description-text");
        VBox.setVgrow((Node)this.descrNode, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)this.descrSubHead, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
    }

    public void setText(String title, String pageRef, String descr) {
        this.descrHead.setText(title);
        this.descrSubHead.setText(pageRef);
        this.descrNode.setText(descr);
    }

    public void setText(HardcopyPluginData data) {
        if (data != null) {
            this.descrHead.setText(data.getName());
            this.descrSubHead.setText(data.getProductName() + " " + data.getPage());
            this.descrNode.setText(data.getHelpText());
        } else {
            this.descrHead.setText(null);
            this.descrSubHead.setText(null);
            this.descrNode.setText(null);
        }
    }
}

