/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.HistoryElement;
import de.rpgframework.genericrpg.modification.Modification;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.PropertyResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.prelle.javafx.AppBarButton;
import org.prelle.javafx.AppBarToggleButton;
import org.prelle.javafx.IconElement;
import org.prelle.javafx.ScreenManagerProvider;
import org.prelle.javafx.SymbolIcon;
import org.prelle.rpgframework.jfx.CharacterDocumentView;
import org.prelle.rpgframework.jfx.HistoryElementBox;
import org.prelle.rpgframework.jfx.HistoryElementSection;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;

public abstract class DevelopmentPage
extends CharacterDocumentView {
    private static final PropertyResourceBundle UI = RPGFrameworkJFXConstants.UI;
    protected HistoryElementSection history;
    private AppBarButton btnAddExp;
    private AppBarToggleButton cbAggregate;
    private AppBarToggleButton btnSort;
    private StringConverter<Modification> converter;
    private SortOrder order;

    public DevelopmentPage(PropertyResourceBundle uiResources) {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    public BooleanProperty aggregatedProperty() {
        return this.cbAggregate.selectedProperty();
    }

    public void setAggregated(boolean value) {
        this.cbAggregate.selectedProperty().setValue(Boolean.valueOf(value));
    }

    public boolean shallBeAggregated() {
        return this.cbAggregate.selectedProperty().get();
    }

    private void initComponents() {
        this.order = SortOrder.OLDEST_FIRST;
        this.history = new HistoryElementSection((ScreenManagerProvider)this, UI.getString("label.development"), UI, this.converter);
        this.btnAddExp = new AppBarButton(UI.getString("label.addreward"), (IconElement)new SymbolIcon("add"));
        this.btnSort = new AppBarToggleButton(this.order.toString(), (Node)new SymbolIcon("sort"));
        this.cbAggregate = new AppBarToggleButton(UI.getString("screen.development.aggregate"), (Node)new SymbolIcon("backtowindow"));
    }

    private void initLayout() {
        this.getCommandBar().setOpen(true);
        this.getSectionList().add((Object)this.history);
        this.getCommandBar().getPrimaryCommands().add((Object)this.btnAddExp);
        this.getCommandBar().getPrimaryCommands().add((Object)this.btnSort);
    }

    private void initInteractivity() {
        this.history.selectedProperty().addListener((ov, o, n) -> {
            if (n != null) {
                HistoryElementBox box = new HistoryElementBox((HistoryElement)n, UI, this.converter);
                this.setDescriptionNode((Node)box);
            } else {
                this.setDescriptionHeading(null);
                this.setDescriptionNode(null);
            }
        });
        this.btnAddExp.setOnAction(event -> this.openAdd());
        this.btnSort.setOnAction(ev -> {
            this.order = this.order == SortOrder.NEWEST_FIRST ? SortOrder.OLDEST_FIRST : SortOrder.NEWEST_FIRST;
            this.btnSort.setText(this.order.toString());
            LogManager.getLogger((String)"rpgframework.jfx").info("Change sort order");
            Collections.sort(this.history.list.getItems(), new Comparator<HistoryElement>(){

                @Override
                public int compare(HistoryElement o1, HistoryElement o2) {
                    Date d2;
                    Date d1 = o1.getEnd() != null ? o1.getEnd() : o1.getStart();
                    Date date = d2 = o2.getEnd() != null ? o2.getEnd() : o2.getStart();
                    if (d1 == null || d2 == null) {
                        return 0;
                    }
                    return d1.compareTo(d2);
                }
            });
            if (this.order == SortOrder.NEWEST_FIRST) {
                Collections.reverse(this.history.list.getItems());
            }
        });
        this.cbAggregate.setOnAction(ev -> {
            LogManager.getLogger((String)"rpgframework.jfx").info("CLICK2");
            this.refresh();
        });
    }

    public void setConverter(StringConverter<Modification> converter) {
        this.converter = converter;
    }

    public abstract void refresh();

    public abstract HistoryElement openAdd();

    public abstract boolean openEdit(HistoryElement var1);

    private static enum SortOrder {
        OLDEST_FIRST,
        NEWEST_FIRST;


        public String toString() {
            return UI.getString("screen.development.sortorder." + this.name().toLowerCase());
        }
    }
}

