/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.ToDoElement;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.prelle.rpgframework.jfx.Section;

public class DoubleSection
extends Section {
    private Section leftSection;
    private Section rightSection;

    public DoubleSection(Section left, Section right) {
        this.leftSection = left;
        this.rightSection = right;
        this.todos.addAll(left.getToDoList());
        this.todos.addAll(right.getToDoList());
        left.getToDoList().addListener((ListChangeListener)new ListChangeListener<ToDoElement>(){

            public void onChanged(ListChangeListener.Change<? extends ToDoElement> c) {
                DoubleSection.this.refreshList();
            }
        });
        right.getToDoList().addListener((ListChangeListener)new ListChangeListener<ToDoElement>(){

            public void onChanged(ListChangeListener.Change<? extends ToDoElement> c) {
                DoubleSection.this.refreshList();
            }
        });
    }

    private void refreshList() {
        this.todos.clear();
        this.todos.addAll(this.leftSection.getToDoList());
        this.todos.addAll(this.rightSection.getToDoList());
    }

    @Override
    public ObservableList<ToDoElement> getToDoList() {
        return this.todos;
    }

    public Section getLeftSection() {
        return this.leftSection;
    }

    public Section getRightSection() {
        return this.rightSection;
    }

    @Override
    public void refresh() {
        this.leftSection.refresh();
        this.rightSection.refresh();
    }
}

