/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.prelle.rpgframework.jfx.FreePointsNodeSkin;

public class FreePointsNode
extends Control {
    static final String DEFAULT_STYLE_CLASS = "free-points";
    private static PseudoClass TOSPEND_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"tospend");
    private static PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private FloatProperty points;
    private StringProperty name;
    BooleanProperty toSpend = new BooleanPropertyBase(false){

        public void invalidated() {
            FreePointsNode.this.pseudoClassStateChanged(TOSPEND_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return FreePointsNode.this;
        }

        public String getName() {
            return "tospend";
        }
    };
    BooleanProperty invalid = new BooleanPropertyBase(false){

        public void invalidated() {
            FreePointsNode.this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, this.get());
        }

        public Object getBean() {
            return FreePointsNode.this;
        }

        public String getName() {
            return "invalid";
        }
    };

    public FreePointsNode() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.points = new SimpleFloatProperty(0.0f);
        this.name = new SimpleStringProperty();
        this.points.addListener((ov, o, n) -> {
            Float val = (Float)n;
            if (val == null || val.floatValue() == 0.0f) {
                this.toSpend.set(false);
                this.invalid.set(false);
            } else if (val.floatValue() < 0.0f) {
                this.toSpend.set(false);
                this.invalid.set(true);
            } else if (val.floatValue() > 0.0f) {
                this.toSpend.set(true);
                this.invalid.set(false);
            }
        });
        this.setSkin((Skin)new FreePointsNodeSkin(this));
    }

    public FloatProperty pointsProperty() {
        return this.points;
    }

    public void setPoints(float value) {
        this.points.set(value);
    }

    public float getPoints() {
        return this.points.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String value) {
        this.name.set((Object)value);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setToSpend(boolean value) {
        this.toSpend.set(value);
    }

    public void setInvalid(boolean invalid) {
        this.invalid.set(invalid);
    }
}

