/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.HardcopyPluginData;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class HelpTextPane
extends VBox {
    private Label heading;
    private Label pageReference;
    private Label helpText;

    public HelpTextPane() {
        this.getStyleClass().add((Object)"description-text");
        this.heading = new Label();
        this.heading.setWrapText(true);
        this.pageReference = new Label();
        this.helpText = new Label();
        this.helpText.setWrapText(true);
        this.heading.getStyleClass().add((Object)"title");
        this.pageReference.getStyleClass().add((Object)"subtitle");
        this.helpText.getStyleClass().add((Object)"body");
        this.getChildren().addAll((Object[])new Node[]{this.heading, this.pageReference, this.helpText});
        VBox.setMargin((Node)this.helpText, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
    }

    public void setData(HardcopyPluginData value) {
        if (value == null) {
            this.heading.setText(null);
            this.pageReference.setText(null);
            this.helpText.setText(null);
        } else {
            this.heading.setText(value.getName());
            this.pageReference.setText(value.getProductName() + " " + value.getPage());
            this.helpText.setText(value.getHelpText());
        }
    }

    public void setData(String name, String ref, String text) {
        this.heading.setText(name);
        this.pageReference.setText(ref);
        this.helpText.setText(text);
    }
}

