/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.HistoryElement;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.Modifyable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.PropertyResourceBundle;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class HistoryElementBox
extends VBox {
    private static final DateFormat FORMAT = DateFormat.getDateInstance(2);

    public HistoryElementBox(HistoryElement data, PropertyResourceBundle RES, StringConverter<Modification> converter) {
        this.setSpacing(10.0);
        this.getStyleClass().addAll((Object[])new String[]{"history-element"});
        this.setMaxWidth(Double.MAX_VALUE);
        this.setAlignment(Pos.TOP_CENTER);
        Label label = new Label(data.getName());
        label.setWrapText(true);
        label.getStyleClass().add((Object)"text-subheader");
        this.getChildren().add((Object)label);
        VBox leftRight = new VBox(10.0);
        leftRight.setAlignment(Pos.TOP_CENTER);
        this.getChildren().add((Object)leftRight);
        ImageView image = new ImageView();
        image.setFitWidth(150.0);
        image.setFitHeight(200.0);
        leftRight.getChildren().add((Object)image);
        if (data.getAdventure() != null && data.getAdventure().getCover() != null) {
            Image img = new Image((InputStream)new ByteArrayInputStream(data.getAdventure().getCover()));
            image.setImage(img);
        }
        VBox pane = new VBox();
        leftRight.getChildren().add((Object)pane);
        if (data.getStart() != null) {
            Object date = FORMAT.format(data.getStart());
            if (data.getStart().getTime() != data.getEnd().getTime()) {
                date = (String)date + " - " + FORMAT.format(data.getEnd());
            }
            Label lblDate = new Label((String)date);
            lblDate.getStyleClass().add((Object)"text-body");
            pane.getChildren().add((Object)lblDate);
        }
        Label lblRewards = new Label(RES.getString("label.history.gained"));
        lblRewards.getStyleClass().add((Object)"text-small-subheader");
        pane.getChildren().add((Object)lblRewards);
        int sumEP = 0;
        for (Object rew : data.getGained()) {
            sumEP += rew.getExperiencePoints();
        }
        Label ep = new Label("   " + sumEP + " " + RES.getString("label.history.exp"));
        pane.getChildren().add((Object)ep);
        for (Modifyable rew : data.getGained()) {
            for (Modification mod : rew.getModifications()) {
                String modString = converter != null ? converter.toString((Object)mod) : mod.toString();
                pane.getChildren().add((Object)new Label("   " + modString));
            }
        }
        Label lblSpent = new Label(RES.getString("label.history.spent"));
        lblSpent.getStyleClass().add((Object)"text-small-subheader");
        pane.getChildren().add((Object)lblSpent);
        for (Modification mod : data.getSpent()) {
            String modString = converter != null ? converter.toString((Object)mod) : mod.toString();
            pane.getChildren().add((Object)new Label("   " + mod.getExpCost() + " " + RES.getString("label.history.exp") + ": " + modString));
        }
    }
}

