/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.HistoryElement;
import de.rpgframework.genericrpg.modification.Modification;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.PropertyResourceBundle;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class HistoryElementListCell
extends ListCell<HistoryElement> {
    private PropertyResourceBundle UI;
    private ReadOnlyObjectProperty<StringConverter<Modification>> converter;
    private Label lbName;
    private Label lbDate;
    private ImageView iView;
    private Label lbExp;
    private HBox bxCollapsed;

    public HistoryElementListCell(PropertyResourceBundle UI, ReadOnlyObjectProperty<StringConverter<Modification>> converter) {
        this.UI = UI;
        this.converter = converter;
        this.lbName = new Label();
        this.lbDate = new Label();
        this.lbExp = new Label();
        this.iView = new ImageView();
        this.iView.setFitHeight(80.0);
        this.iView.setPreserveRatio(true);
        VBox bxNameDate = new VBox(5.0, new Node[]{this.lbName, this.lbDate});
        Region space = new Region();
        space.setMaxWidth(Double.MAX_VALUE);
        this.bxCollapsed = new HBox(new Node[]{this.iView, bxNameDate, space, this.lbExp});
        HBox.setHgrow((Node)space, (Priority)Priority.ALWAYS);
        this.lbExp.setStyle("-fx-font-size: 200%; -fx-font-weight: bold");
        this.lbName.getStyleClass().add((Object)"base");
    }

    public void updateItem(HistoryElement item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.lbName.setText(item.getName());
            if (item.getEnd() != null) {
                this.lbDate.setText(DateFormat.getDateInstance(2).format(item.getEnd()));
            } else if (item.getStart() != null) {
                this.lbDate.setText(DateFormat.getDateInstance(2).format(item.getStart()));
            }
            this.lbExp.setText(String.valueOf(item.getTotalExperience()));
            if (item.getAdventure() != null && item.getAdventure().getCover() != null) {
                Image img = new Image((InputStream)new ByteArrayInputStream(item.getAdventure().getCover()));
                this.iView.setImage(img);
            } else {
                this.iView.setImage(null);
            }
            this.setGraphic((Node)this.bxCollapsed);
        }
    }
}

