/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.HistoryElement;
import de.rpgframework.genericrpg.modification.Modification;
import java.util.List;
import java.util.PropertyResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.util.StringConverter;
import org.prelle.javafx.ScreenManagerProvider;
import org.prelle.rpgframework.jfx.HistoryElementListCell;
import org.prelle.rpgframework.jfx.SingleSection;

public class HistoryElementSection
extends SingleSection {
    private PropertyResourceBundle UI;
    private ObjectProperty<StringConverter<Modification>> converter = new SimpleObjectProperty();
    protected ListView<HistoryElement> list;

    public HistoryElementSection(ScreenManagerProvider provider, String title, PropertyResourceBundle UI, StringConverter<Modification> converter) {
        super(provider, title, null);
        this.UI = UI;
        this.converter.set(converter);
        this.initComponents();
        this.initLayout();
        this.list.setStyle("-fx-min-width: 35em; -fx-pref-width: 50em; -fx-pref-height: 55em;");
        this.list.setMaxHeight(Double.MAX_VALUE);
    }

    private void initComponents() {
        this.list = new ListView();
        this.list.setCellFactory(lv -> new HistoryElementListCell(this.UI, (ReadOnlyObjectProperty<StringConverter<Modification>>)this.converter));
    }

    private void initLayout() {
        this.setContent((Node)this.list);
    }

    public void setData(List<HistoryElement> data) {
        this.list.getItems().setAll(data);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.list.refresh();
    }

    public ReadOnlyObjectProperty<HistoryElement> selectedProperty() {
        return this.list.getSelectionModel().selectedItemProperty();
    }
}

