/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.ModifyableValue;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.prelle.rpgframework.jfx.ModifyableValueView;

public class ModifyableValueViewSkin<T>
extends SkinBase<ModifyableValueView<T>> {
    private TableView<ModifyableValue<T>> content;
    private TableColumn<ModifyableValue<T>, String> colName;
    private TableColumn<ModifyableValue<T>, Number> colStart;
    private TableColumn<ModifyableValue<T>, Number> colPoints;
    private TableColumn<ModifyableValue<T>, Number> colMod;
    private TableColumn<ModifyableValue<T>, Number> colValue;
    private TableColumn<ModifyableValue<T>, Number> colCost;

    public ModifyableValueViewSkin(ModifyableValueView<T> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.getChildren().add(this.content);
    }

    private void initComponents() {
        this.content = new TableView();
        this.content.itemsProperty().bind(((ModifyableValueView)this.getSkinnable()).itemsProperty());
        this.colName = new TableColumn("Name");
        this.colStart = new TableColumn("Start");
        this.colPoints = new TableColumn("Punkte");
        this.colMod = new TableColumn("Mod.");
        this.colValue = new TableColumn("Wert");
        this.colCost = new TableColumn("Kosten");
        this.colName.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<ModifyableValue<T>, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ModifyableValue<T>, String> param) {
                String name = ((ModifyableValue)param.getValue()).getModifyable().toString();
                if (((ModifyableValueView)ModifyableValueViewSkin.this.getSkinnable()).getNameConverter() != null) {
                    name = ((ModifyableValueView)ModifyableValueViewSkin.this.getSkinnable()).getNameConverter().toString(((ModifyableValue)param.getValue()).getModifyable());
                }
                return new SimpleStringProperty(name);
            }
        });
        this.colPoints.setCellValueFactory((Callback)new PropertyValueFactory("points"));
        this.colMod.setCellValueFactory((Callback)new PropertyValueFactory("modifier"));
        this.colValue.setCellValueFactory((Callback)new PropertyValueFactory("modifiedValue"));
    }

    private void initLayout() {
        this.content.setMaxWidth(Double.MAX_VALUE);
    }
}

