/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class NumericalValueField<T, V extends NumericalValue<T>>
extends HBox {
    private V value;
    private NumericalValueController<T, V> control;
    private Button dec;
    private Button inc;
    private TextField tfValue;

    public NumericalValueField(V val, NumericalValueController<T, V> ctrl) {
        this.value = val;
        this.control = ctrl;
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.refresh();
    }

    private void initComponents() {
        this.dec = new Button("\ue0c6");
        this.inc = new Button("\ue0c5");
        this.tfValue = new TextField();
        this.tfValue.setPrefColumnCount(2);
        this.tfValue.setEditable(false);
        this.tfValue.setFocusTraversable(false);
    }

    private void initLayout() {
        this.getChildren().addAll((Object[])new Node[]{this.dec, this.tfValue, this.inc});
    }

    private void initStyle() {
        this.inc.getStyleClass().add((Object)"mini-button");
        this.dec.getStyleClass().add((Object)"mini-button");
        this.setStyle("-fx-min-width: 7.5em");
    }

    private void initInteractivity() {
        this.dec.setOnAction(ev -> this.control.decrease(this.value));
        this.inc.setOnAction(ev -> this.control.increase(this.value));
    }

    public void refresh() {
        this.dec.setDisable(!this.control.canBeDecreased(this.value));
        this.inc.setDisable(!this.control.canBeIncreased(this.value));
        this.tfValue.setText(String.valueOf(this.value.getPoints()));
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.tfValue.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

