/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.WindowMode;
import org.prelle.rpgframework.jfx.DescriptionPane;

public class OptionalDescriptionPane
extends HBox
implements ResponsiveControl {
    private Node description;

    public OptionalDescriptionPane() {
        this.setStyle("-fx-spacing: 2em");
    }

    public OptionalDescriptionPane(Node content, Node description) {
        this.description = description;
        this.getChildren().addAll((Object[])new Node[]{content, description});
        HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)description, (Priority)Priority.ALWAYS);
        this.setStyle("-fx-spacing: 2em");
    }

    public void setChildren(Node content, Node description) {
        this.description = description;
        HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)description, (Priority)Priority.ALWAYS);
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{content, description});
    }

    public void setResponsiveMode(WindowMode value) {
        if (this.description != null) {
            this.description.setManaged(value == WindowMode.EXPANDED);
            this.description.setVisible(value == WindowMode.EXPANDED);
        }
    }

    public void setText(String title, String pageRef, String descr) {
        this.getChildren().retainAll((Object[])new Node[]{(Node)this.getChildren().get(0)});
        this.description = new DescriptionPane();
        ((DescriptionPane)this.description).setText(title, pageRef, descr);
        this.getChildren().addAll((Object[])new Node[]{this.description});
    }

    public void setDescriptionNode(Node description) {
        this.getChildren().retainAll((Object[])new Node[]{(Node)this.getChildren().get(0)});
        this.description = description;
        this.getChildren().addAll((Object[])new Node[]{description});
    }
}

