/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.SelectableItem;
import de.rpgframework.genericrpg.SelectedValue;
import de.rpgframework.genericrpg.SelectionController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.rpgframework.jfx.SelectionControllerNode;

public class SelectionControlTwoColumnSkin<T extends SelectableItem, V extends SelectedValue<T>>
extends SkinBase<SelectionControllerNode<T, V>> {
    private ListView<T> listPossible;
    private ListView<V> listSelected;
    private Label lblAvailable;
    private Label lblSelected;
    private Callback<ListView<T>, ListCell<T>> cfAvailable;
    private Callback<ListView<V>, ListCell<V>> cfSelected;
    private HBox columns;

    protected SelectionControlTwoColumnSkin(SelectionControllerNode<T, V> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cfAvailable = new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> param) {
                ListCell cell = ((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory() != null ? (ListCell)((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory().call(param) : SelectionControlTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectionControlTwoColumnSkin.this.mouseClickedAvailable(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectionControlTwoColumnSkin.this.dragDetectedAvailable(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.cfSelected = new Callback<ListView<V>, ListCell<V>>(){

            public ListCell<V> call(ListView<V> param) {
                ListCell cell = ((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory() != null ? (ListCell)((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory().call(param) : SelectionControlTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectionControlTwoColumnSkin.this.mouseClickedSelected(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectionControlTwoColumnSkin.this.dragDetectedSelected(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.listPossible = new ListView();
        this.listPossible.setCellFactory(this.cfAvailable);
        this.listSelected = new ListView();
        this.listSelected.setCellFactory(this.cfSelected);
        this.lblAvailable = new Label(" " + ((SelectionControllerNode)this.getSkinnable()).getAvailableHeading());
        this.lblSelected = new Label(" " + ((SelectionControllerNode)this.getSkinnable()).getSelectedHeading());
        this.lblAvailable.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.lblSelected.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.listPossible.setStyle(((SelectionControllerNode)this.getSkinnable()).getAvailableStyle());
        this.listSelected.setStyle(((SelectionControllerNode)this.getSkinnable()).getSelectedStyle());
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        this.columns = new HBox();
        this.columns.setStyle("-fx-spacing: 1em;");
        this.getChildren().add((Object)this.columns);
    }

    private void initLayout() {
        this.columns.getChildren().clear();
        if (((SelectionControllerNode)this.getSkinnable()).getShowHeadings()) {
            VBox col1 = new VBox(new Node[]{this.lblAvailable, this.listPossible});
            VBox col2 = new VBox(new Node[]{this.lblSelected, this.listSelected});
            col1.setStyle("-fx-spacing: 1em");
            col2.setStyle("-fx-spacing: 1em");
            VBox.setVgrow(this.listPossible, (Priority)Priority.ALWAYS);
            VBox.setVgrow(this.listSelected, (Priority)Priority.ALWAYS);
            this.columns.getChildren().addAll((Object[])new Node[]{col1, col2});
        } else {
            this.columns.getChildren().addAll((Object[])new Node[]{this.listPossible, this.listSelected});
        }
    }

    private void initInteractivity() {
        ((SelectionControllerNode)this.getSkinnable()).availableProperty().addListener((ov, o, n) -> {
            this.listPossible.getItems().clear();
            this.listPossible.getItems().addAll((Collection)n);
        });
        ((SelectionControllerNode)this.getSkinnable()).selectedProperty().addListener((ov, o, n) -> {
            this.listSelected.getItems().clear();
            this.listSelected.getItems().addAll((Collection)n);
        });
        ((SelectionControllerNode)this.getSkinnable()).getAvailable().addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                SelectionControlTwoColumnSkin.this.listPossible.getItems().clear();
                SelectionControlTwoColumnSkin.this.listPossible.getItems().addAll(((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getAvailable());
            }
        });
        ((SelectionControllerNode)this.getSkinnable()).getSelected().addListener(new ListChangeListener<SelectedValue<T>>(){

            public void onChanged(ListChangeListener.Change<? extends SelectedValue<T>> c) {
                SelectionControlTwoColumnSkin.this.listSelected.getItems().clear();
                SelectionControlTwoColumnSkin.this.listSelected.getItems().addAll(((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getSelected());
            }
        });
        ((SelectionControllerNode)this.getSkinnable()).showHeadingsProperty().addListener((ov, o, n) -> this.initLayout());
        ((SelectionControllerNode)this.getSkinnable()).availableHeadingProperty().addListener((ov, o, n) -> this.lblAvailable.setText(" " + n));
        ((SelectionControllerNode)this.getSkinnable()).selectedHeadingProperty().addListener((ov, o, n) -> this.lblSelected.setText(" " + n));
        ((SelectionControllerNode)this.getSkinnable()).availableStyleProperty().addListener((ov, o, n) -> this.listPossible.setStyle(n));
        ((SelectionControllerNode)this.getSkinnable()).selectedStyleProperty().addListener((ov, o, n) -> this.listSelected.setStyle(n));
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((SelectionControllerNode)this.getSkinnable()).setShowHelpFor(n));
        this.listSelected.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((SelectionControllerNode)this.getSkinnable()).setShowHelpFor(n != null ? (SelectableItem)n.getModifyable() : null));
        this.listPossible.setOnDragOver(ev -> this.dragOverAvailable((DragEvent)ev));
        this.listSelected.setOnDragOver(ev -> this.dragOverSelected((DragEvent)ev));
        this.listPossible.setOnDragDropped(ev -> this.dragDroppedAvailable((DragEvent)ev));
        this.listSelected.setOnDragDropped(ev -> this.dragDroppedSelected((DragEvent)ev));
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListCell<T>(){

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    Node currentNode = this.getGraphic();
                    Node newNode = (Node)item;
                    if (currentNode == null || !currentNode.equals(newNode)) {
                        this.setGraphic(newNode);
                    }
                } else {
                    this.setText(item == null ? "null" : item.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    private void userSelects(T toSelect) {
        SelectionController ctrl = ((SelectionControllerNode)this.getSkinnable()).getController();
        if (ctrl.canBeSelected(toSelect)) {
            if (ctrl.needsOptionSelection(toSelect)) {
                List options = ctrl.getOptions(toSelect);
                if (((SelectionControllerNode)this.getSkinnable()).getOptionCallback() != null) {
                    Platform.runLater(() -> {
                        Object choice = ((SelectionControllerNode)this.getSkinnable()).getOptionCallback().apply((SelectableItem)toSelect, options);
                        if (choice != null) {
                            ctrl.select(toSelect, choice);
                        }
                    });
                }
            } else {
                ctrl.select(toSelect);
            }
        }
    }

    private void mouseClickedAvailable(ListCell<T> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.userSelects((SelectableItem)cell.getItem());
        }
    }

    private void mouseClickedSelected(ListCell<V> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2 && ((SelectionControllerNode)this.getSkinnable()).getController().canBeDeselected((SelectedValue)cell.getItem())) {
            ((SelectionControllerNode)this.getSkinnable()).getController().deselect((SelectedValue)cell.getItem());
        }
    }

    protected void dragDetectedAvailable(ListCell<T> cell, MouseEvent event) {
        SelectableItem data = (SelectableItem)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((SelectionControllerNode)this.getSkinnable()).getController().canBeSelected(data)) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = data.getTypeId() + ":" + data.getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    protected void dragDetectedSelected(ListCell<V> cell, MouseEvent event) {
        SelectedValue data = (SelectedValue)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((SelectionControllerNode)this.getSkinnable()).getController().canBeDeselected(data)) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = ((SelectableItem)data.getModifyable()).getTypeId() + ":" + ((SelectableItem)data.getModifyable()).getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    private void dragOverSelected(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dragDroppedSelected(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            SelectableItem toSelect = null;
            for (SelectableItem tmp : ((SelectionControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = tmp.getTypeId() + ":" + tmp.getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                this.userSelects(toSelect);
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void dragOverAvailable(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dragDroppedAvailable(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            SelectedValue toSelect = null;
            for (SelectedValue tmp : ((SelectionControllerNode)this.getSkinnable()).getController().getSelected()) {
                String cmp = ((SelectableItem)tmp.getModifyable()).getTypeId() + ":" + ((SelectableItem)tmp.getModifyable()).getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                ((SelectionControllerNode)this.getSkinnable()).getController().deselect(toSelect);
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }
}

