/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.genericrpg.SelectableItem;
import de.rpgframework.genericrpg.SelectedValue;
import de.rpgframework.genericrpg.SelectionController;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.prelle.rpgframework.jfx.RPGFrameworkJFXConstants;
import org.prelle.rpgframework.jfx.SelectionControlTwoColumnSkin;

public class SelectionControllerNode<T extends SelectableItem, V extends SelectedValue<T>>
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "selection-control";
    private ObjectProperty<SelectionController<T, V>> control;
    private ObjectProperty<ObservableList<T>> availableProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<ObservableList<V>> selectedProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty;
    private ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty;
    private ObjectProperty<BiFunction<T, List<?>, ?>> optionCallbackProperty;
    private BooleanProperty showHeadingsProperty;
    private StringProperty availableHeadingProperty;
    private StringProperty selectedHeadingProperty;
    private StringProperty availablePlaceholderProperty;
    private StringProperty selectedPlaceholderProperty;
    private ObjectProperty<T> showHelpForProperty;
    private StringProperty availableStyleProperty;
    private StringProperty selectedStyleProperty;

    public SelectionControllerNode(SelectionController<T, V> control) {
        if (control == null) {
            throw new NullPointerException("Controller may not be null");
        }
        this.control = new SimpleObjectProperty(control);
        this.availableCellFactoryProperty = new SimpleObjectProperty();
        this.selectedCellFactoryProperty = new SimpleObjectProperty();
        this.optionCallbackProperty = new SimpleObjectProperty();
        this.showHeadingsProperty = new SimpleBooleanProperty(true);
        this.availableHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.available"));
        this.selectedHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.selected"));
        this.availablePlaceholderProperty = new SimpleStringProperty();
        this.selectedPlaceholderProperty = new SimpleStringProperty();
        this.showHelpForProperty = new SimpleObjectProperty();
        this.availableStyleProperty = new SimpleStringProperty();
        this.selectedStyleProperty = new SimpleStringProperty();
        this.setSkin((Skin)new SelectionControlTwoColumnSkin(this));
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.control.addListener((ov, o, n) -> this.refresh());
        this.refresh();
    }

    public ObjectProperty<SelectionController<T, V>> getControllerProperty() {
        return this.control;
    }

    public SelectionController<T, V> getController() {
        return (SelectionController)this.control.get();
    }

    public void setController(SelectionController<T, V> value) {
        this.control.set(value);
    }

    public void refresh() {
        ((ObservableList)this.availableProperty.get()).clear();
        ((ObservableList)this.availableProperty.get()).addAll((Collection)((SelectionController)this.control.get()).getAvailable());
        ((ObservableList)this.selectedProperty.get()).clear();
        ((ObservableList)this.selectedProperty.get()).addAll((Collection)((SelectionController)this.control.get()).getSelected());
    }

    public ObjectProperty<ObservableList<T>> availableProperty() {
        return this.availableProperty;
    }

    public ObservableList<T> getAvailable() {
        return (ObservableList)this.availableProperty.get();
    }

    public void setAvailable(ObservableList<T> value) {
        this.availableProperty.setValue(value);
    }

    public ObjectProperty<ObservableList<V>> selectedProperty() {
        return this.selectedProperty;
    }

    public ObservableList<V> getSelected() {
        return (ObservableList)this.selectedProperty.get();
    }

    public void setSelected(ObservableList<V> value) {
        this.selectedProperty.setValue(value);
    }

    public ObjectProperty<BiFunction<T, List<?>, ?>> optionCallbackProperty() {
        return this.optionCallbackProperty;
    }

    public BiFunction<T, List<?>, ?> getOptionCallback() {
        return (BiFunction)this.optionCallbackProperty.get();
    }

    public void setOptionCallback(BiFunction<T, List<?>, ?> value) {
        this.optionCallbackProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty() {
        return this.availableCellFactoryProperty;
    }

    public Callback<ListView<T>, ListCell<T>> getAvailableCellFactory() {
        return (Callback)this.availableCellFactoryProperty.get();
    }

    public void setAvailableCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.availableCellFactoryProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty() {
        return this.selectedCellFactoryProperty;
    }

    public Callback<ListView<V>, ListCell<V>> getSelectedCellFactory() {
        return (Callback)this.selectedCellFactoryProperty.get();
    }

    public void setSelectedCellFactory(Callback<ListView<V>, ListCell<V>> value) {
        this.selectedCellFactoryProperty.setValue(value);
    }

    public BooleanProperty showHeadingsProperty() {
        return this.showHeadingsProperty;
    }

    public boolean getShowHeadings() {
        return this.showHeadingsProperty.get();
    }

    public void setShowHeadings(boolean value) {
        this.showHeadingsProperty.set(value);
    }

    public StringProperty availableHeadingProperty() {
        return this.availableHeadingProperty;
    }

    public String getAvailableHeading() {
        return (String)this.availableHeadingProperty.get();
    }

    public void setAvailableHeading(String value) {
        this.availableHeadingProperty.set((Object)value);
    }

    public StringProperty selectedHeadingProperty() {
        return this.selectedHeadingProperty;
    }

    public String getSelectedHeading() {
        return (String)this.selectedHeadingProperty.get();
    }

    public void setSelectedHeading(String value) {
        this.selectedHeadingProperty.set((Object)value);
    }

    public StringProperty availablePlaceholderProperty() {
        return this.availablePlaceholderProperty;
    }

    public String getAvailablePlaceholder() {
        return (String)this.availablePlaceholderProperty.get();
    }

    public void setAvailablePlaceholder(String value) {
        this.availablePlaceholderProperty.set((Object)value);
    }

    public StringProperty selectedPlaceholderProperty() {
        return this.selectedPlaceholderProperty;
    }

    public String getSelectedPlaceholder() {
        return (String)this.selectedPlaceholderProperty.get();
    }

    public void setSelectedPlaceholder(String value) {
        this.selectedPlaceholderProperty.set((Object)value);
    }

    public ObjectProperty<T> showHelpForProperty() {
        return this.showHelpForProperty;
    }

    public T getShowHelpFor() {
        return (T)((SelectableItem)this.showHelpForProperty.get());
    }

    public void setShowHelpFor(T value) {
        this.showHelpForProperty.setValue(value);
    }

    public StringProperty availableStyleProperty() {
        return this.availableStyleProperty;
    }

    public String getAvailableStyle() {
        return (String)this.availableStyleProperty.get();
    }

    public void setAvailableStyle(String value) {
        this.availableStyleProperty.set((Object)value);
    }

    public StringProperty selectedStyleProperty() {
        return this.selectedStyleProperty;
    }

    public String getSelectedStyle() {
        return (String)this.selectedStyleProperty.get();
    }

    public void setSelectedStyle(String value) {
        this.selectedStyleProperty.set((Object)value);
    }
}

