/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import de.rpgframework.HardcopyPluginData;
import de.rpgframework.genericrpg.ModifyableValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.rpgframework.jfx.ThreeColumnControllerGUI;
import org.prelle.rpgframework.jfx.ThreeColumnPane;

public class ThreeColumnControllerGUISkin<T extends HardcopyPluginData, M extends ModifyableValue<T>>
extends SkinBase<ThreeColumnControllerGUI<T, M>> {
    private ThreeColumnPane content;
    private ListView<T> lvAvailable;
    private ListView<M> lvSelected;
    private Label descTitle;
    private Label descPageRef;
    private Label descText;
    private HBox trash;
    private VBox bxInfo;
    private Label phAvailable;
    private Label phSelected;

    public ThreeColumnControllerGUISkin(ThreeColumnControllerGUI<T, M> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.getChildren().add((Object)this.content);
    }

    private void initComponents() {
        this.lvAvailable = new ListView();
        this.lvSelected = new ListView();
        this.phAvailable = new Label("No content");
        this.phAvailable.setWrapText(true);
        this.phSelected = new Label("No content");
        this.phSelected.setWrapText(true);
        this.lvAvailable.setPlaceholder((Node)this.phAvailable);
        this.lvSelected.setPlaceholder((Node)this.phSelected);
        this.descTitle = new Label();
        this.descPageRef = new Label();
        this.descText = new Label();
        this.descText.setWrapText(true);
        Region spacing = new Region();
        spacing.setMaxHeight(Double.MAX_VALUE);
        spacing.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)spacing, (Priority)Priority.ALWAYS);
        this.trash = new HBox();
        this.trash.setAlignment(Pos.CENTER);
        this.trash.setMaxWidth(Double.MAX_VALUE);
        this.bxInfo = new VBox(20.0);
        this.bxInfo.getChildren().addAll((Object[])new Node[]{this.descTitle, this.descPageRef, this.descText, spacing, this.trash});
        this.content = new ThreeColumnPane();
    }

    private void initStyle() {
        this.lvAvailable.setId("available");
        this.lvAvailable.getStyleClass().addAll((Object[])new String[]{"content", "available"});
        this.lvSelected.getStyleClass().addAll((Object[])new String[]{"content", "selected"});
        this.lvSelected.setId("selected");
        this.bxInfo.getStyleClass().addAll((Object[])new String[]{"content", "info"});
        this.bxInfo.setId("info");
        this.descTitle.getStyleClass().add((Object)"section-head");
        this.descPageRef.getStyleClass().add((Object)"text-secondary");
        this.descText.getStyleClass().add((Object)"text-body");
        this.content.column1HeaderProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).column1HeaderProperty());
        this.content.column2HeaderProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).column2HeaderProperty());
        this.content.column3HeaderProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).column3HeaderProperty());
    }

    private void initLayout() {
        this.lvAvailable.setStyle("-fx-min-width: 10em");
        this.lvSelected.setStyle("-fx-min-width: 10em");
        this.bxInfo.setStyle("-fx-min-width: 10em");
        this.lvAvailable.setMaxHeight(Double.MAX_VALUE);
        this.lvSelected.setMaxHeight(Double.MAX_VALUE);
        this.bxInfo.setMaxHeight(Double.MAX_VALUE);
        this.content.setColumn1Node((Node)this.lvAvailable);
        this.content.setColumn2Node((Node)this.lvSelected);
        this.content.setColumn3Node((Node)this.bxInfo);
    }

    private void initInteractivity() {
        this.content.headersVisibleProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).headersVisibleProperty());
        this.lvAvailable.itemsProperty().bind(((ThreeColumnControllerGUI)this.getSkinnable()).itemsAvailableProperty());
        this.lvSelected.itemsProperty().bind(((ThreeColumnControllerGUI)this.getSkinnable()).itemsSelectedProperty());
        this.phAvailable.textProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).placeholderAvailableProperty());
        this.phSelected.textProperty().bind((ObservableValue)((ThreeColumnControllerGUI)this.getSkinnable()).placeholderSelectedProperty());
        this.lvAvailable.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((ThreeColumnControllerGUI)this.getSkinnable()).selectedProperty().set(n));
        this.lvSelected.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            if (n != null) {
                ((ThreeColumnControllerGUI)this.getSkinnable()).selectedProperty().set((Object)((HardcopyPluginData)n.getModifyable()));
            }
        });
        ((ThreeColumnControllerGUI)this.getSkinnable()).selectedProperty().addListener((ov, o, n) -> {
            if (n == null) {
                this.descTitle.setText(null);
                this.descPageRef.setText(null);
                this.descText.setText(null);
            } else {
                this.descTitle.setText(n.toString());
                this.descPageRef.setText(n.getProductName() + " " + n.getPage());
                this.descText.setText(n.getHelpText());
            }
        });
        ((ThreeColumnControllerGUI)this.getSkinnable()).trashAreaProperty().addListener((ov, o, n) -> {
            this.trash.getChildren().clear();
            if (n != null) {
                this.trash.getChildren().add(n);
            }
        });
        this.lvAvailable.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> param) {
                ListCell cell = (ListCell)((ThreeColumnControllerGUI)ThreeColumnControllerGUISkin.this.getSkinnable()).getCellFactoryAvailable().call(param);
                cell.setOnDragDetected(event -> ThreeColumnControllerGUISkin.this.dragFromAvailableStarted((MouseEvent)event, cell));
                cell.setOnDragDropped(event -> ThreeColumnControllerGUISkin.this.dropAtAvailable((DragEvent)event));
                return cell;
            }
        });
        this.lvSelected.setCellFactory(new Callback<ListView<M>, ListCell<M>>(){

            public ListCell<M> call(ListView<M> param) {
                ListCell cell = (ListCell)((ThreeColumnControllerGUI)ThreeColumnControllerGUISkin.this.getSkinnable()).getCellFactorySelected().call(param);
                cell.setOnDragDetected(event -> ThreeColumnControllerGUISkin.this.dragFromSelectedStarted((MouseEvent)event, cell));
                cell.setOnDragDropped(event -> ThreeColumnControllerGUISkin.this.dropAtSelected((DragEvent)event));
                return cell;
            }
        });
        this.lvAvailable.setOnDragOver(event -> this.dragOver((DragEvent)event));
        this.lvSelected.setOnDragOver(event -> this.dragOver((DragEvent)event));
    }

    private void dragFromAvailableStarted(MouseEvent event, ListCell<T> cell) {
        if (((ThreeColumnControllerGUI)this.getSkinnable()).getDragAvailable() != null) {
            ((ThreeColumnControllerGUI)this.getSkinnable()).getDragAvailable().accept(event, (MouseEvent)((HardcopyPluginData)cell.getItem()));
        }
    }

    private void dragFromSelectedStarted(MouseEvent event, ListCell<M> cell) {
        if (((ThreeColumnControllerGUI)this.getSkinnable()).getDragSelected() != null) {
            ((ThreeColumnControllerGUI)this.getSkinnable()).getDragSelected().accept(event, (ModifyableValue)cell.getItem());
        }
    }

    private void dragOver(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dropAtAvailable(DragEvent event) {
        if (((ThreeColumnControllerGUI)this.getSkinnable()).getDropAtAvailable() != null) {
            ((ThreeColumnControllerGUI)this.getSkinnable()).getDropAtAvailable().accept(event);
        }
    }

    private void dropAtSelected(DragEvent event) {
        if (((ThreeColumnControllerGUI)this.getSkinnable()).getDropAtSelected() != null) {
            ((ThreeColumnControllerGUI)this.getSkinnable()).getDropAtSelected().accept(event);
        }
    }
}

