/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.prelle.rpgframework.jfx.ThreeColumnPane;

public class ThreeColumnPaneFluentSkin
extends SkinBase<ThreeColumnPane> {
    private HBox content;
    private VBox column1;
    private VBox column2;
    private VBox column3;
    private Label header1;
    private Label header2;
    private Label header3;

    public ThreeColumnPaneFluentSkin(ThreeColumnPane control) {
        super((Control)control);
        this.initComponents();
        this.initStyle();
        this.initLayout();
        this.initInteractivity();
        this.getChildren().add((Object)this.content);
    }

    private void initComponents() {
        this.column1 = new VBox();
        this.column2 = new VBox();
        this.column3 = new VBox();
        this.header1 = new Label();
        this.header2 = new Label();
        this.header3 = new Label();
        this.content = new HBox();
    }

    private void initStyle() {
        this.header1.getStyleClass().addAll((Object[])new String[]{"title"});
        this.header2.getStyleClass().addAll((Object[])new String[]{"title"});
        this.header3.getStyleClass().addAll((Object[])new String[]{"title"});
        this.column1.getStyleClass().add((Object)"column1");
        this.column2.getStyleClass().add((Object)"column2");
        this.column3.getStyleClass().add((Object)"column3");
        this.content.getStyleClass().add((Object)"three-column-pane");
    }

    private void initLayout() {
        this.content.setStyle("-fx-spacing: 1em");
        this.content.setMaxWidth(Double.MAX_VALUE);
        this.column1.setStyle("-fx-spacing: 0.5em");
        this.column2.setStyle("-fx-spacing: 0.5em");
        this.column3.setStyle("-fx-spacing: 0.5em");
        this.column1.setMaxHeight(Double.MAX_VALUE);
        this.column2.setMaxHeight(Double.MAX_VALUE);
        this.column3.setMaxHeight(Double.MAX_VALUE);
        this.content.getChildren().addAll((Object[])new Node[]{this.column1, this.column2, this.column3});
        this.content.setMaxHeight(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.column1, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.column2, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.column3, (Priority)Priority.ALWAYS);
    }

    private void initInteractivity() {
        this.header1.textProperty().bind((ObservableValue)((ThreeColumnPane)this.getSkinnable()).column1HeaderProperty());
        this.header2.textProperty().bind((ObservableValue)((ThreeColumnPane)this.getSkinnable()).column2HeaderProperty());
        this.header3.textProperty().bind((ObservableValue)((ThreeColumnPane)this.getSkinnable()).column3HeaderProperty());
        ((ThreeColumnPane)this.getSkinnable()).headersVisibleProperty().addListener((ov, o, n) -> {
            if (n.booleanValue()) {
                this.column1.getChildren().add(0, (Object)this.header1);
                this.column2.getChildren().add(0, (Object)this.header2);
                this.column3.getChildren().add(0, (Object)this.header3);
            } else {
                this.column1.getChildren().remove((Object)this.header1);
                this.column2.getChildren().remove((Object)this.header2);
                this.column3.getChildren().remove((Object)this.header3);
            }
        });
        ((ThreeColumnPane)this.getSkinnable()).column1NodeProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.column1.getChildren().remove(o);
            }
            if (n != null) {
                this.column1.getChildren().add(n);
                VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
            }
        });
        ((ThreeColumnPane)this.getSkinnable()).column2NodeProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.column2.getChildren().remove(o);
            }
            if (n != null) {
                this.column2.getChildren().add(n);
                VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
            }
        });
        ((ThreeColumnPane)this.getSkinnable()).column3NodeProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.column3.getChildren().remove(o);
            }
            if (n != null) {
                this.column3.getChildren().add(n);
                VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
            }
        });
    }
}

