/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx.skin;

import de.rpgframework.genericrpg.ToDoElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.prelle.javafx.WindowMode;
import org.prelle.rpgframework.jfx.DoubleSection;
import org.prelle.rpgframework.jfx.FreePointsNode;
import org.prelle.rpgframework.jfx.Section;

public class CharacterDocumentViewPane
extends StackPane {
    private static final Logger logger = LogManager.getLogger((String)"rpgframework.jfx");
    @FXML
    private ObservableList<Section> sectionListProperty = FXCollections.observableArrayList();
    @FXML
    private IntegerProperty pointsFreeProperty = new SimpleIntegerProperty();
    @FXML
    private StringProperty pointsNameProperty = new SimpleStringProperty();
    private GridPane col1And2Grid;
    private FreePointsNode points;
    private ScrollPane scroll;
    private HBox innerLayout;
    private Region bufRight;
    private Region bufLeft;

    public CharacterDocumentViewPane() {
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.col1And2Grid = new GridPane();
        this.col1And2Grid.getStyleClass().add((Object)"character-document-view-grid");
        this.scroll = new ScrollPane((Node)this.col1And2Grid);
        this.scroll.getStyleClass().add((Object)"character-document-view-scroll");
        this.innerLayout = new HBox();
        this.innerLayout.getStyleClass().add((Object)"character-document-view-layout");
        this.points = new FreePointsNode();
    }

    private void initLayout() {
        this.scroll.setFitToWidth(true);
        this.bufLeft = new Region();
        this.bufLeft.getStyleClass().add((Object)"character-document-view-buffer-left");
        this.bufLeft.setMaxWidth(Double.MAX_VALUE);
        this.bufRight = new Region();
        this.bufRight.getStyleClass().add((Object)"character-document-view-buffer-right");
        this.bufRight.setMaxWidth(Double.MAX_VALUE);
        this.innerLayout.getChildren().addAll((Object[])new Node[]{this.bufLeft, this.scroll, this.bufRight});
        HBox.setHgrow((Node)this.bufLeft, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.scroll, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.bufRight, (Priority)Priority.SOMETIMES);
        AnchorPane pointsLayer = new AnchorPane(new Node[]{this.points});
        AnchorPane.setLeftAnchor((Node)this.points, (Double)5.0);
        AnchorPane.setTopAnchor((Node)this.points, (Double)5.0);
        pointsLayer.setMouseTransparent(true);
        this.getChildren().addAll((Object[])new Node[]{this.innerLayout, pointsLayer});
        StackPane.setAlignment((Node)this.points, (Pos)Pos.TOP_LEFT);
        StackPane.setMargin((Node)this.points, (Insets)new Insets(20.0));
        this.reloadSections();
    }

    private void initInteractivity() {
        this.getSectionList().addListener((ListChangeListener)new ListChangeListener<Section>(){

            public void onChanged(ListChangeListener.Change<? extends Section> c) {
                CharacterDocumentViewPane.this.reloadSections();
            }
        });
        this.pointsFreeProperty().addListener((ov, o, n) -> this.points.setPoints(((Integer)n).intValue()));
        this.pointsNameProperty().addListener((ov, o, n) -> this.points.setName((String)n));
    }

    public ObservableList<Section> getSectionList() {
        return this.sectionListProperty;
    }

    public IntegerProperty pointsFreeProperty() {
        return this.pointsFreeProperty;
    }

    public void setPointsFree(int value) {
        this.pointsFreeProperty.set(value);
    }

    public int getPointsFree() {
        return this.pointsFreeProperty.get();
    }

    public StringProperty pointsNameProperty() {
        return this.pointsNameProperty;
    }

    public void setPointsNameProperty(String value) {
        this.pointsNameProperty.set((Object)value);
    }

    public String getPointsNameProperty() {
        return (String)this.pointsNameProperty.get();
    }

    private static List<Label> convertToDoElements(List<ToDoElement> todos) {
        ArrayList<Label> ret = new ArrayList<Label>();
        for (ToDoElement todo : todos) {
            Label l = new Label(todo.getMessage());
            l.setWrapText(true);
            switch (todo.getSeverity()) {
                case STOPPER: {
                    l.setStyle("-fx-text-fill: textcolor-stopper");
                    break;
                }
                case WARNING: {
                    l.setStyle("-fx-text-fill: textcolor-warning");
                    break;
                }
                case INFO: {
                    l.setStyle("-fx-text-fill: textcolor-info");
                }
            }
            ret.add(l);
        }
        return ret;
    }

    private void reloadSections() {
        logger.debug("Reload sections");
        this.col1And2Grid.getChildren().clear();
        if (this.getSectionList() == null) {
            return;
        }
        int y = 0;
        for (final Section section : this.getSectionList()) {
            logger.debug(" Section " + section);
            if (y > 0) {
                Region spacing = new Region();
                spacing.getStyleClass().add((Object)"character-document-view-spacing");
                this.col1And2Grid.add((Node)spacing, 0, y, 2, 1);
                ++y;
            }
            final VBox bxToDosV = new VBox();
            bxToDosV.setId("todoV");
            bxToDosV.setStyle("-fx-spacing: 0.3em;");
            bxToDosV.getStyleClass().add((Object)"character-document-view-todos");
            final VBox bxToDosH = new VBox();
            bxToDosH.setId("todoH");
            bxToDosH.setStyle("-fx-spacing: 0.5em");
            if (section.getToDoList() != null) {
                bxToDosV.getChildren().addAll(CharacterDocumentViewPane.convertToDoElements(section.getToDoList()));
                bxToDosH.getChildren().addAll(CharacterDocumentViewPane.convertToDoElements(section.getToDoList()));
                section.getToDoList().addListener((ListChangeListener)new ListChangeListener<ToDoElement>(){

                    public void onChanged(ListChangeListener.Change<? extends ToDoElement> c) {
                        bxToDosV.getChildren().clear();
                        bxToDosV.getChildren().addAll(CharacterDocumentViewPane.convertToDoElements(section.getToDoList()));
                        bxToDosH.getChildren().clear();
                        bxToDosH.getChildren().addAll(CharacterDocumentViewPane.convertToDoElements(section.getToDoList()));
                    }
                });
            }
            Section bxContent = null;
            if (section instanceof DoubleSection) {
                HBox sideBySide = new HBox();
                Section col1 = ((DoubleSection)section).getLeftSection();
                Section col2 = ((DoubleSection)section).getRightSection();
                this.col1And2Grid.add((Node)col1, 1, y);
                this.col1And2Grid.add((Node)col2, 2, y);
                GridPane.setVgrow((Node)col1, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)col2, (Priority)Priority.SOMETIMES);
                GridPane.setHgrow((Node)col1, (Priority)Priority.ALWAYS);
                bxContent = new VBox(new Node[]{bxToDosH, sideBySide});
                sideBySide.setMaxHeight(Double.MAX_VALUE);
                VBox.setVgrow((Node)sideBySide, (Priority)Priority.ALWAYS);
            } else {
                bxContent = section;
                this.col1And2Grid.add((Node)section, 1, y, 2, 1);
                GridPane.setVgrow((Node)section, (Priority)Priority.NEVER);
            }
            this.col1And2Grid.add((Node)bxToDosV, 0, y);
            GridPane.setFillWidth((Node)bxContent, (Boolean)true);
            GridPane.setHgrow((Node)bxContent, (Priority)Priority.ALWAYS);
            ++y;
        }
    }

    private List<Node> getNestedChildren(Parent parent) {
        ArrayList<Node> ret = new ArrayList<Node>();
        ret.addAll((Collection<Node>)parent.getChildrenUnmodifiable());
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (!(child instanceof Parent)) continue;
            ret.addAll((Collection<Node>)((Parent)child).getChildrenUnmodifiable());
        }
        return ret;
    }

    public void setResponsiveMode(WindowMode value) {
        this.bufRight.setVisible(value != WindowMode.MINIMAL);
        this.bufRight.setManaged(value != WindowMode.MINIMAL);
        this.bufLeft.setVisible(value != WindowMode.MINIMAL);
        this.bufLeft.setManaged(value != WindowMode.MINIMAL);
        for (Node node : this.getNestedChildren((Parent)this.col1And2Grid)) {
            if (node.getId() == null) continue;
            if (node.getId().equals("todoV")) {
                node.setVisible(value == WindowMode.EXPANDED);
                node.setManaged(value == WindowMode.EXPANDED);
            }
            if (!node.getId().equals("todoH")) continue;
            node.setVisible(value != WindowMode.EXPANDED);
            node.setManaged(value != WindowMode.EXPANDED);
        }
    }
}

