/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.rpgframework.jfx.skin;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.prelle.rpgframework.jfx.Section;
import org.prelle.rpgframework.jfx.SingleSection;

public class SingleSectionSkin
extends SkinBase<SingleSection> {
    public static final String DEFAULT_STYLE_CLASS = "character-document-view";
    private Label heading;
    private HBox headingLine;
    private HBox buttons;
    private VBox bxContent;

    public SingleSectionSkin(SingleSection control) {
        super((Control)control);
        this.initComponents();
        this.initLayout();
        this.initStyle(Section.SectionType.SINGLE);
        this.initInteractivity();
    }

    private void initComponents() {
        this.heading = new Label(((SingleSection)this.getSkinnable()).getTitle());
        this.buttons = new HBox();
        this.bxContent = new VBox();
    }

    private void initStyle(Section.SectionType type) {
        this.heading.getStyleClass().add((Object)"character-document-view-title");
        if (type != null && type == Section.SectionType.LEFT) {
            this.heading.getStyleClass().addAll((Object[])new String[]{"character-document-view-title-left"});
        } else if (type != null && type == Section.SectionType.RIGHT) {
            this.heading.getStyleClass().addAll((Object[])new String[]{"character-document-view-title-right"});
        }
        this.bxContent.getStyleClass().add((Object)"character-document-view-content");
        this.buttons.setStyle("-fx-spacing: 0.2em; -fx-background-color: -fx-outer-border;");
    }

    private void initLayout() {
        this.heading.setMaxWidth(Double.MAX_VALUE);
        this.headingLine = new HBox(new Node[]{this.heading, this.buttons});
        this.headingLine.setMaxHeight(Double.MAX_VALUE);
        this.headingLine.setAlignment(Pos.BOTTOM_LEFT);
        HBox.setHgrow((Node)this.heading, (Priority)Priority.ALWAYS);
        this.bxContent.setMaxWidth(Double.MAX_VALUE);
        this.bxContent.setMaxHeight(Double.MAX_VALUE);
        this.bxContent.getChildren().add((Object)this.headingLine);
        if (((SingleSection)this.getSkinnable()).getContent() != null) {
            ((SingleSection)this.getSkinnable()).getContent().getStyleClass().addAll((Object[])new String[]{"character-document-view-section-content"});
            this.bxContent.getChildren().add((Object)((SingleSection)this.getSkinnable()).getContent());
            VBox.setVgrow((Node)((SingleSection)this.getSkinnable()).getContent(), (Priority)Priority.ALWAYS);
        }
        if (((SingleSection)this.getSkinnable()).getDeleteButton() != null) {
            this.buttons.getChildren().add((Object)((SingleSection)this.getSkinnable()).getDeleteButton());
        }
        if (((SingleSection)this.getSkinnable()).getAddButton() != null) {
            this.buttons.getChildren().add((Object)((SingleSection)this.getSkinnable()).getAddButton());
        }
        this.getChildren().add((Object)this.bxContent);
        VBox.setVgrow((Node)this.bxContent, (Priority)Priority.ALWAYS);
    }

    private void initInteractivity() {
        this.heading.textProperty().bind((ObservableValue)((SingleSection)this.getSkinnable()).titleProperty());
        ((SingleSection)this.getSkinnable()).contentProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.bxContent.getChildren().remove(o);
            }
            if (n != null) {
                n.getStyleClass().addAll((Object[])new String[]{"character-document-view-section-content"});
                this.bxContent.getChildren().add(n);
                VBox.setVgrow((Node)((SingleSection)this.getSkinnable()).getContent(), (Priority)Priority.ALWAYS);
                VBox.setVgrow((Node)n, (Priority)Priority.ALWAYS);
            }
        });
        ((SingleSection)this.getSkinnable()).deleteButtonProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.buttons.getChildren().remove(o);
            }
            if (n != null) {
                this.buttons.getChildren().add(n);
            }
        });
        ((SingleSection)this.getSkinnable()).addButtonProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.buttons.getChildren().remove(o);
            }
            if (n != null) {
                this.buttons.getChildren().add(n);
            }
        });
    }
}

