/**
 * 
 */
package de.rpgframework.character;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.UUID;

import de.rpgframework.core.RoleplayingSystem;

/**
 * @author prelle
 *
 */
public abstract class CharacterHandle {

	protected UUID uuid;
	protected RoleplayingSystem rules;
	protected String name;
	protected String desc = "-";
	protected Date lastModified;
	
	protected transient RuleSpecificCharacterObject<?,?,?,?> parsedCharac;

	
	//-------------------------------------------------------------------
	public CharacterHandle() {
	}
	
	//-------------------------------------------------------------------
	public CharacterHandle(UUID uuid, RoleplayingSystem rules, String name, String desc, Date lastModified) {
		super();
		this.uuid = uuid;
		this.rules = rules;
		this.name = name;
		this.desc = desc;
		this.lastModified = lastModified;
	}

	//-------------------------------------------------------------------
	public String getName() {
		return name;
	}

	//-------------------------------------------------------------------
	public String getShortDescription() {
		if (parsedCharac!=null)
			return parsedCharac.getShortDescription();
		return desc;
	}

	//-------------------------------------------------------------------
	public void setShortDescription(String desc) {
		this.desc = desc;
	}

	//-------------------------------------------------------------------
	public RoleplayingSystem getRuleIdentifier() {
		return rules;
	}
	
	//-------------------------------------------------------------------
	public Date getLastModified() {
		return lastModified;
	}
	
	//-------------------------------------------------------------------
	public UUID getUUID() {
		return uuid;
	}

	//-------------------------------------------------------------------
	public void setName(String value) {
		this.name= value;
	}

	//-------------------------------------------------------------------
	public void setRuleIdentifier(RoleplayingSystem rules) {
		this.rules = rules;
	}

	//-------------------------------------------------------------------
	public void setLastModified(Date lastModified) {
		this.lastModified = lastModified;
	}

	//--------------------------------------------------------------------
	public RuleSpecificCharacterObject getCharacter() {
		return parsedCharac;
	}

	//--------------------------------------------------------------------
	public void setCharacter(RuleSpecificCharacterObject charac) throws IOException {
		this.parsedCharac = charac;
	}
	//-------------------------------------------------------------------
	public abstract Path getPath();

}
