package de.rpgframework.genericrpg.items;

import java.util.ArrayList;
import java.util.Arrays;

import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.Modifyable;

public class ItemAttributeObjectValue<A extends IItemAttribute> extends ItemAttributeValue<A> implements Modifyable {

	protected Object value;

	//--------------------------------------------------------------------
	public ItemAttributeObjectValue(ItemAttributeDefinition def) {
		super((A)def.getModifyable());
		value = null;
	}

	//--------------------------------------------------------------------
	public ItemAttributeObjectValue(IItemAttribute attrib, Object value) {
		super((A)attrib);
		this.value = value;
		if (value instanceof Float)
			throw new RuntimeException("Use ItemAttributeFloatValue instead");
	}

	//-------------------------------------------------------------------
	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() {
		ItemAttributeObjectValue<A> copy = new ItemAttributeObjectValue<A>( this.attribute, value);
		copy.addModifications( new ArrayList<Modification>(this.modifications) );
		return copy;
	}

	//--------------------------------------------------------------------
	public String toString() {
		String modified = modifications.isEmpty() ? "" : " ("+getModifiedValue()+")";
		if (value instanceof int[])
			return "OBJ:"+Arrays.toString((int[])value)+modified+" ("+modifications+")";
		return "OBJ:"+value+modified+" ("+modifications+")";
	}

	//-------------------------------------------------------------------
	/**
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public <T> T getValue() {
		return (T) value;
	}

	//-------------------------------------------------------------------
	public void setValue(Object value) {
		this.value = value;
		if (value instanceof Float)
			throw new RuntimeException("Use ItemAttributeFloatValue instead");
	}

	//--------------------------------------------------------------------
	public <T> T getModifiedValue() {
		return attribute.calculateModifiedValue(value, modifications);
	}

}
