package de.rpgframework.genericrpg;

import java.util.ArrayList;
import java.util.List;

import de.rpgframework.genericrpg.data.DataSet;

/**
 * @author prelle
 *
 */
public class LicenseManager {
	
	private static List<String> globalSets = new ArrayList<>();
	private static ThreadLocal<List<String>> userDataSets = new ThreadLocal<>();

	//-------------------------------------------------------------------
	public static boolean hasGlobalLicense(DataSet set) {
		String key = set.getRules().name()+"/"+set.getID();
		return globalSets.contains(key);
	}

	//-------------------------------------------------------------------
	public static void storeGlobalLicenses(List<String> sets) {
		globalSets.addAll(sets);
	}

	//-------------------------------------------------------------------
	public static void storeUserLicensedDatasets(List<String> sets) {
		userDataSets.set(sets);
	}

	//-------------------------------------------------------------------
	public static boolean hasUserLicensed(DataSet set) {
		if (userDataSets.get()==null) return false;
		String key = set.getRules().name()+"/"+set.getID();
		return userDataSets.get().contains(key);
	}
	
}
