package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.SelectedValue;
import de.rpgframework.genericrpg.modification.ModifyableImpl;

/**
 * @author prelle
 *
 */
public abstract class ItemAttributeValue<A extends IItemAttribute> extends ModifyableImpl implements SelectedValue<A>, Cloneable {

	protected A attribute;

	//-------------------------------------------------------------------
	public ItemAttributeValue(A attr) {
		this.attribute = attr;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.genericrpg.SelectedValue#getModifyable()
	 */
	@Override
	public A getModifyable() {
		return attribute;
	}

	//-------------------------------------------------------------------
	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public abstract Object clone() ;

}
