/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.character;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.RoleplayingSystem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.UUID;

public abstract class CharacterHandle {
    protected UUID uuid;
    protected RoleplayingSystem rules;
    protected String name;
    protected String desc = "-";
    protected Date lastModified;
    protected transient RuleSpecificCharacterObject<?, ?, ?, ?> parsedCharac;

    public CharacterHandle() {
    }

    public CharacterHandle(UUID uuid, RoleplayingSystem rules, String name, String desc, Date lastModified) {
        this.uuid = uuid;
        this.rules = rules;
        this.name = name;
        this.desc = desc;
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        if (this.parsedCharac != null) {
            return this.parsedCharac.getShortDescription();
        }
        return this.desc;
    }

    public void setShortDescription(String desc) {
        this.desc = desc;
    }

    public RoleplayingSystem getRuleIdentifier() {
        return this.rules;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setRuleIdentifier(RoleplayingSystem rules) {
        this.rules = rules;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public RuleSpecificCharacterObject getCharacter() {
        return this.parsedCharac;
    }

    public void setCharacter(RuleSpecificCharacterObject charac) throws IOException {
        this.parsedCharac = charac;
    }

    public abstract Path getPath();
}

