/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.modification.CheckModification;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.Modifyable;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.List;

public interface ModifyableNumericalValue<T>
extends Modifyable,
NumericalValue<T> {
    default public int getModifiedValue() {
        return this.getModifiedValue(ValueType.NATURAL, ValueType.AUGMENTED);
    }

    default public int getModifiedValue(ValueType ... typeArray) {
        List<ValueType> types = List.of(typeArray);
        boolean isNaturalOrAugmented = types.contains((Object)ValueType.NATURAL) || types.contains((Object)ValueType.AUGMENTED);
        int val = isNaturalOrAugmented ? this.getDistributed() : 0;
        return val += this.getModifier(typeArray);
    }

    default public int getModifier() {
        return this.getModifier(ValueType.NATURAL, ValueType.AUGMENTED);
    }

    default public int getModifier(ValueType ... typeArray) {
        List<ValueType> types = List.of(typeArray);
        double val = 0.0;
        for (Modification mod : this.getIncomingModifications()) {
            if (mod instanceof CheckModification) continue;
            if (mod instanceof ValueModification) {
                ValueModification vMod = (ValueModification)mod;
                if (!types.contains((Object)vMod.getSet())) continue;
                val += vMod.getValueAsDouble();
                continue;
            }
            if (!(mod instanceof DataItemModification)) continue;
            val += 1.0;
        }
        return (int)Math.round(val);
    }
}

